/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ElectrolysisRecipe
extends MekanismRecipe
implements Predicate<FluidStack> {
    private final FluidStackIngredient input;
    private final GasStack leftGasOutput;
    private final GasStack rightGasOutput;
    private final FloatingLong energyMultiplier;

    public ElectrolysisRecipe(ResourceLocation id, FluidStackIngredient input, FloatingLong energyMultiplier, GasStack leftGasOutput, GasStack rightGasOutput) {
        super(id);
        this.input = input;
        this.energyMultiplier = energyMultiplier;
        this.leftGasOutput = leftGasOutput;
        this.rightGasOutput = rightGasOutput;
    }

    public FluidStackIngredient getInput() {
        return this.input;
    }

    public GasStack getLeftGasOutputRepresentation() {
        return this.leftGasOutput;
    }

    public GasStack getRightGasOutputRepresentation() {
        return this.rightGasOutput;
    }

    @Override
    public boolean test(@Nonnull FluidStack fluidStack) {
        return this.input.test(fluidStack);
    }

    @Contract(value="_ -> new", pure=true)
    public Pair<@NonNull GasStack, @NonNull GasStack> getOutput(FluidStack input) {
        return Pair.of((Object)this.leftGasOutput.copy(), (Object)this.rightGasOutput.copy());
    }

    public FloatingLong getEnergyMultiplier() {
        return this.energyMultiplier;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.write(buffer);
        this.energyMultiplier.writeToBuffer(buffer);
        this.leftGasOutput.writeToPacket(buffer);
        this.rightGasOutput.writeToPacket(buffer);
    }
}

