/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache.chemical;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemStackToChemicalCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NonNull STACK> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler;

    public ItemStackToChemicalCachedRecipe(RECIPE recipe, IInputHandler<@NonNull ItemStack> inputHandler, IOutputHandler<@NonNull STACK> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.inputHandler.getRecipeInput(((ItemStackToChemicalRecipe)this.recipe).getInput());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((ItemStackToChemicalRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ItemStackToChemicalRecipe)this.recipe).getOutput(recipeItem), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ItemStackToChemicalRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.inputHandler.getRecipeInput(((ItemStackToChemicalRecipe)this.recipe).getInput());
        if (recipeItem.func_190926_b()) {
            return;
        }
        this.inputHandler.use(recipeItem, operations);
        this.outputHandler.handleOutput(((ItemStackToChemicalRecipe)this.recipe).getOutput(recipeItem), operations);
    }
}

