/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.PacketDropperUse;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class GuiChemicalBar<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends GuiBar<ChemicalInfoProvider<STACK>>
implements IJEIIngredientHelper {
    private final boolean horizontal;

    public GuiChemicalBar(IGuiWrapper gui, ChemicalInfoProvider<STACK> infoProvider, int x, int y, int width, int height, boolean horizontal) {
        super(AtlasTexture.field_110575_b, gui, infoProvider, x, y, width, height);
        this.horizontal = horizontal;
    }

    @Override
    protected void renderBarOverlay(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        double level;
        Object stored = ((ChemicalInfoProvider)this.getHandler()).getStack();
        if (!((ChemicalStack)stored).isEmpty() && (level = ((ChemicalInfoProvider)this.getHandler()).getLevel()) > 0.0) {
            Object type = ((ChemicalStack)stored).getType();
            MekanismRenderer.color(type);
            TextureAtlasSprite icon = MekanismRenderer.getChemicalTexture(type);
            if (this.horizontal) {
                this.drawTiledSprite(matrix, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230689_k_ - 2, (int)(level * (double)(this.field_230688_j_ - 2)), this.field_230689_k_ - 2, icon, GuiUtils.TilingDirection.DOWN_RIGHT);
            } else {
                this.drawTiledSprite(matrix, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230689_k_ - 2, this.field_230688_j_ - 2, (int)(level * (double)(this.field_230689_k_ - 2)), icon, GuiUtils.TilingDirection.DOWN_RIGHT);
            }
            MekanismRenderer.resetColor();
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
            if (this.guiObj instanceof GuiMekanismTile && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemGaugeDropper) {
                PacketDropperUse.TankType tankType = null;
                Object type = ((ChemicalStack)((ChemicalInfoProvider)this.getHandler()).getStack()).getType();
                if (type instanceof Gas) {
                    tankType = PacketDropperUse.TankType.GAS_TANK;
                } else if (type instanceof InfuseType) {
                    tankType = PacketDropperUse.TankType.INFUSION_TANK;
                } else if (type instanceof Pigment) {
                    tankType = PacketDropperUse.TankType.PIGMENT_TANK;
                } else if (type instanceof Slurry) {
                    tankType = PacketDropperUse.TankType.SLURRY_TANK;
                }
                if (tankType != null) {
                    int index = ((ChemicalInfoProvider)this.getHandler()).getTankIndex();
                    if (index != -1) {
                        PacketDropperUse.DropperAction action = button == 0 ? (Screen.func_231173_s_() ? PacketDropperUse.DropperAction.DUMP_TANK : PacketDropperUse.DropperAction.FILL_DROPPER) : PacketDropperUse.DropperAction.DRAIN_DROPPER;
                        Mekanism.packetHandler.sendToServer(new PacketDropperUse(((GuiMekanismTile)this.guiObj).getTileEntity().func_174877_v(), action, tankType, index));
                    }
                    return true;
                }
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public Object getIngredient() {
        Object chemicalStack = ((ChemicalInfoProvider)this.getHandler()).getStack();
        return ((ChemicalStack)chemicalStack).isEmpty() ? null : chemicalStack;
    }

    public static <STACK extends ChemicalStack<?>, TANK extends IChemicalTank<?, STACK>> ChemicalInfoProvider<STACK> getProvider(final TANK tank, final List<TANK> tanks) {
        return new ChemicalInfoProvider<STACK>(){

            @Override
            @Nonnull
            public STACK getStack() {
                return tank.getStack();
            }

            @Override
            public int getTankIndex() {
                return tanks.indexOf(tank);
            }

            @Override
            public ITextComponent getTooltip() {
                if (tank.isEmpty()) {
                    return MekanismLang.EMPTY.translate(new Object[0]);
                }
                if (tank.getStored() == Long.MAX_VALUE) {
                    return MekanismLang.GENERIC_STORED.translate(tank.getType(), MekanismLang.INFINITE);
                }
                return MekanismLang.GENERIC_STORED_MB.translate(tank.getType(), tank.getStored());
            }

            @Override
            public double getLevel() {
                return (double)tank.getStored() / (double)tank.getCapacity();
            }
        };
    }

    public static interface ChemicalInfoProvider<STACK extends ChemicalStack<?>>
    extends GuiBar.IBarInfoHandler {
        @Nonnull
        public STACK getStack();

        public int getTankIndex();
    }
}

