/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ColorButton
extends MekanismButton {
    private final Supplier<EnumColor> colorSupplier;

    public ColorButton(IGuiWrapper gui, int x, int y, int width, int height, Supplier<EnumColor> colorSupplier, Runnable onPress, Runnable onRightClick) {
        super(gui, x, y, width, height, StringTextComponent.field_240750_d_, onPress, onRightClick, (onHover, matrix, xAxis, yAxis) -> {
            EnumColor color = (EnumColor)colorSupplier.get();
            if (color != null) {
                gui.displayTooltip(matrix, color.getColoredName(), xAxis, yAxis);
            } else {
                gui.displayTooltip(matrix, (ITextComponent)MekanismLang.NONE.translate(new Object[0]), xAxis, yAxis);
            }
        });
        this.colorSupplier = colorSupplier;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        EnumColor color = this.colorSupplier.get();
        if (color != null) {
            ColorButton.func_238467_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)MekanismRenderer.getColorARGB(color, 1.0f));
            MekanismRenderer.resetColor();
        }
    }
}

