/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.common.MekanismLang;
import mekanism.common.tags.MekanismTags;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;

public class GuiCrystallizerScreen
extends GuiTexturedElement {
    private static final SlotType SLOT = SlotType.ORE;
    private final GuiInnerScreen innerScreen;
    private final int slotX;
    private final List<ItemStack> iterStacks = new ArrayList<ItemStack>();
    private ItemStack renderStack = ItemStack.field_190927_a;
    private int stackSwitch = 0;
    private int stackIndex = 0;
    @Nonnull
    private Slurry prevSlurry = MekanismAPI.EMPTY_SLURRY;
    private final IOreInfo oreInfo;

    public GuiCrystallizerScreen(IGuiWrapper gui, int x, int y, IOreInfo oreInfo) {
        super(SLOT.getTexture(), gui, x, y, 115, 42);
        this.innerScreen = new GuiInnerScreen(gui, x, y, this.field_230688_j_, this.field_230689_k_, () -> {
            ArrayList<Object> ret = new ArrayList<Object>();
            BoxedChemicalStack boxedChemical = oreInfo.getInputChemical();
            if (!boxedChemical.isEmpty()) {
                ret.add(TextComponentUtil.build(boxedChemical));
                if (boxedChemical.getChemicalType() == ChemicalType.SLURRY && !this.renderStack.func_190926_b()) {
                    ret.add(MekanismLang.GENERIC_PARENTHESIS.translate(this.renderStack));
                } else {
                    ChemicalCrystallizerRecipe recipe = oreInfo.getRecipe();
                    if (recipe == null) {
                        ret.add(MekanismLang.NO_RECIPE.translate(new Object[0]));
                    } else {
                        ret.add(MekanismLang.GENERIC_PARENTHESIS.translate(recipe.getOutput(boxedChemical)));
                    }
                }
            }
            return ret;
        });
        this.oreInfo = oreInfo;
        this.slotX = this.field_230690_l_ + 115 - SLOT.getWidth();
        this.field_230693_o_ = false;
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.innerScreen.renderForeground(matrix, mouseX, mouseY);
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        this.innerScreen.drawBackground(matrix, mouseX, mouseY, partialTicks);
        GuiCrystallizerScreen.minecraft.field_71446_o.func_110577_a(this.getResource());
        GuiCrystallizerScreen.func_238463_a_((MatrixStack)matrix, (int)this.slotX, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)SLOT.getWidth(), (int)SLOT.getHeight(), (int)SLOT.getWidth(), (int)SLOT.getHeight());
        if (!this.renderStack.func_190926_b()) {
            this.guiObj.renderItem(matrix, this.renderStack, this.slotX + 1, this.field_230691_m_ + 1);
        }
    }

    @Override
    public void tick() {
        BoxedChemicalStack boxedChemical = this.oreInfo.getInputChemical();
        if (boxedChemical.getChemicalType() == ChemicalType.SLURRY) {
            Slurry inputSlurry = (Slurry)boxedChemical.getChemicalStack().getType();
            if (this.prevSlurry != inputSlurry) {
                this.prevSlurry = inputSlurry;
                this.iterStacks.clear();
                if (!this.prevSlurry.isEmptyType() && !this.prevSlurry.isIn(MekanismTags.Slurries.DIRTY)) {
                    ITag<Item> oreTag = this.prevSlurry.getOreTag();
                    if (oreTag != null) {
                        for (Item ore : oreTag.func_230236_b_()) {
                            this.iterStacks.add(new ItemStack((IItemProvider)ore));
                        }
                    }
                } else {
                    this.renderStack = ItemStack.field_190927_a;
                }
                this.stackSwitch = 0;
                this.stackIndex = -1;
            }
            if (this.iterStacks.isEmpty()) {
                this.renderStack = ItemStack.field_190927_a;
            } else {
                if (this.stackSwitch > 0) {
                    --this.stackSwitch;
                }
                if (this.stackSwitch == 0) {
                    this.stackSwitch = 20;
                    if (this.stackIndex == -1 || this.stackIndex == this.iterStacks.size() - 1) {
                        this.stackIndex = 0;
                    } else if (this.stackIndex < this.iterStacks.size() - 1) {
                        ++this.stackIndex;
                    }
                    this.renderStack = this.iterStacks.get(this.stackIndex);
                }
            }
        }
    }

    public static interface IOreInfo {
        @Nonnull
        public BoxedChemicalStack getInputChemical();

        @Nullable
        public ChemicalCrystallizerRecipe getRecipe();
    }
}

