/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiResizeControls
extends GuiSideHolder {
    private final MekanismImageButton expandButton;
    private final MekanismImageButton shrinkButton;
    private final Consumer<ResizeType> resizeHandler;
    private int tooltipTicks;
    private static final ResourceLocation MINUS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "minus.png");
    private static final ResourceLocation PLUS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "plus.png");

    public GuiResizeControls(IGuiWrapper gui, int y, Consumer<ResizeType> resizeHandler) {
        super(gui, -26, y, 39, true);
        this.resizeHandler = resizeHandler;
        this.expandButton = new MekanismImageButton(gui, this.field_230690_l_ + 4, this.field_230691_m_ + 5, 19, 9, 19, 9, PLUS, () -> this.handleResize(ResizeType.EXPAND_Y));
        this.addChild(this.expandButton);
        this.shrinkButton = new MekanismImageButton(gui, this.field_230690_l_ + 4, this.field_230691_m_ + 25, 19, 9, 19, 9, MINUS, () -> this.handleResize(ResizeType.SHRINK_Y));
        this.addChild(this.shrinkButton);
        this.updateButtonState();
        this.field_230693_o_ = true;
    }

    @Override
    public void tick() {
        super.tick();
        this.tooltipTicks = Math.max(0, this.tooltipTicks - 1);
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        if (this.tooltipTicks > 0 && !this.expandButton.field_230693_o_) {
            this.displayTooltip(matrix, (ITextComponent)MekanismLang.QIO_COMPENSATE_TOOLTIP.translate(new Object[0]), mouseX, mouseY);
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawScaledCenteredText(matrix, (ITextComponent)MekanismLang.HEIGHT.translate(new Object[0]), (float)this.relativeX + 13.5f, (float)this.relativeY + 15.5f, this.titleTextColor(), 0.7f);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        super.func_230982_a_(mouseX, mouseY);
        if (!this.expandButton.field_230693_o_ && mouseX >= (double)this.expandButton.field_230690_l_ && mouseX < (double)(this.expandButton.field_230690_l_ + this.expandButton.func_230998_h_()) && mouseY >= (double)this.expandButton.field_230691_m_ && mouseY < (double)(this.expandButton.field_230691_m_ + this.expandButton.func_238483_d_())) {
            this.tooltipTicks = 100;
        }
    }

    @Override
    protected void colorTab() {
        MekanismRenderer.color(SpecialColors.TAB_RESIZE_CONTROLS);
    }

    private void handleResize(ResizeType type) {
        this.resizeHandler.accept(type);
        this.updateButtonState();
    }

    private void updateButtonState() {
        int index = this.getIndex();
        this.expandButton.field_230693_o_ = index < QIOItemViewerContainer.getSlotsYMax();
        this.shrinkButton.field_230693_o_ = index > 2;
    }

    private int getIndex() {
        return MekanismConfig.client.qioItemViewerSlotsY.get();
    }

    public static enum ResizeType {
        EXPAND_X,
        EXPAND_Y,
        SHRINK_X,
        SHRINK_Y;

    }
}

