/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.filter.transporter;

import com.mojang.blaze3d.matrix.MatrixStack;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.filter.GuiItemStackFilter;
import mekanism.client.gui.element.filter.transporter.GuiSorterFilterHelper;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.text.InputValidator;
import mekanism.common.MekanismLang;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.util.text.ITextComponent;

public class GuiSorterItemStackFilter
extends GuiItemStackFilter<SorterItemStackFilter, TileEntityLogisticalSorter>
implements GuiSorterFilterHelper {
    private GuiTextField minField;
    private GuiTextField maxField;

    public static GuiSorterItemStackFilter create(IGuiWrapper gui, TileEntityLogisticalSorter tile) {
        return new GuiSorterItemStackFilter(gui, (gui.getWidth() - 195) / 2, 30, tile, null);
    }

    public static GuiSorterItemStackFilter edit(IGuiWrapper gui, TileEntityLogisticalSorter tile, SorterItemStackFilter filter) {
        return new GuiSorterItemStackFilter(gui, (gui.getWidth() - 195) / 2, 30, tile, filter);
    }

    private GuiSorterItemStackFilter(IGuiWrapper gui, int x, int y, TileEntityLogisticalSorter tile, SorterItemStackFilter origFilter) {
        super(gui, x, y, 195, 90, tile, origFilter);
    }

    @Override
    protected int getLeftButtonX() {
        return this.field_230690_l_ + 24;
    }

    @Override
    protected void init() {
        super.init();
        this.addSorterDefaults(this.guiObj, (SorterFilter)this.filter, this.getSlotOffset(), this::addChild);
        this.minField = new GuiTextField(this.guiObj, this.relativeX + 169, this.relativeY + 32, 20, 11);
        this.addChild(this.minField);
        this.minField.setMaxStringLength(2);
        this.minField.setInputValidator(InputValidator.DIGIT);
        this.minField.setText("" + ((SorterItemStackFilter)this.filter).min);
        this.maxField = new GuiTextField(this.guiObj, this.relativeX + 169, this.relativeY + 44, 20, 11);
        this.addChild(this.maxField);
        this.maxField.setMaxStringLength(2);
        this.maxField.setInputValidator(InputValidator.DIGIT);
        this.maxField.setText("" + ((SorterItemStackFilter)this.filter).max);
        this.addChild(new MekanismImageButton(this.guiObj, this.field_230690_l_ + 148, this.field_230691_m_ + 57, 11, 14, this.getButtonLocation("silk_touch"), () -> {
            ((SorterItemStackFilter)this.filter).sizeMode = !((SorterItemStackFilter)this.filter).sizeMode;
        }, (onHover, matrix, xAxis, yAxis) -> {
            if (((TileEntityLogisticalSorter)this.tile).singleItem && ((SorterItemStackFilter)this.filter).sizeMode) {
                this.displayTooltip(matrix, (ITextComponent)MekanismLang.SIZE_MODE_CONFLICT.translate(new Object[0]), xAxis, yAxis);
            } else {
                this.displayTooltip(matrix, (ITextComponent)MekanismLang.SIZE_MODE.translate(new Object[0]), xAxis, yAxis);
            }
        }));
        this.addChild(new MekanismImageButton(this.guiObj, this.field_230690_l_ + 148, this.field_230691_m_ + 70, 11, 14, this.getButtonLocation("fuzzy"), () -> {
            ((SorterItemStackFilter)this.filter).fuzzyMode = !((SorterItemStackFilter)this.filter).fuzzyMode;
        }, this.getOnHover(MekanismLang.FUZZY_MODE)));
    }

    @Override
    protected void validateAndSave() {
        if (((SorterItemStackFilter)this.filter).hasFilter()) {
            if (this.minField.getText().isEmpty() || this.maxField.getText().isEmpty()) {
                this.filterSaveFailed(MekanismLang.ITEM_FILTER_SIZE_MISSING);
            } else {
                int min = Integer.parseInt(this.minField.getText());
                int max = Integer.parseInt(this.maxField.getText());
                if (max >= min && max <= 64) {
                    ((SorterItemStackFilter)this.filter).min = min;
                    ((SorterItemStackFilter)this.filter).max = max;
                    this.saveFilter();
                } else if (min > max) {
                    this.filterSaveFailed(MekanismLang.ITEM_FILTER_MAX_LESS_THAN_MIN);
                } else {
                    this.filterSaveFailed(MekanismLang.ITEM_FILTER_OVER_SIZED);
                }
            }
        } else {
            this.filterSaveFailed(this.getNoFilterSaveError());
        }
    }

    @Override
    protected SorterItemStackFilter createNewFilter() {
        return new SorterItemStackFilter();
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.renderSorterForeground(matrix, (SorterFilter)this.filter);
        this.drawString(matrix, (ITextComponent)MekanismLang.MIN.translate(""), this.relativeX + 148, this.relativeY + 33, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)MekanismLang.MAX.translate(""), this.relativeX + 148, this.relativeY + 45, this.titleTextColor());
        if (((TileEntityLogisticalSorter)this.tile).singleItem && ((SorterItemStackFilter)this.filter).sizeMode) {
            this.drawString(matrix, (ITextComponent)MekanismLang.ITEM_FILTER_SIZE_MODE.translateColored(EnumColor.RED, BooleanStateDisplay.OnOff.of(true)), this.relativeX + 161, this.relativeY + 59, this.titleTextColor());
        } else {
            this.drawString(matrix, BooleanStateDisplay.OnOff.of(((SorterItemStackFilter)this.filter).sizeMode).getTextComponent(), this.relativeX + 161, this.relativeY + 59, this.titleTextColor());
        }
        this.drawString(matrix, BooleanStateDisplay.OnOff.of(((SorterItemStackFilter)this.filter).fuzzyMode).getTextComponent(), this.relativeX + 161, this.relativeY + 72, this.titleTextColor());
    }
}

