/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.progress;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.progress.IProgressInfoHandler;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.jei.interfaces.IJEIRecipeArea;
import net.minecraft.util.ResourceLocation;

public class GuiProgress
extends GuiTexturedElement
implements IJEIRecipeArea<GuiProgress> {
    protected final IProgressInfoHandler handler;
    protected final ProgressType type;
    private ResourceLocation[] recipeCategories;

    public GuiProgress(IProgressInfoHandler.IBooleanProgressInfoHandler handler, ProgressType type, IGuiWrapper gui, int x, int y) {
        this((IProgressInfoHandler)handler, type, gui, x, y);
    }

    public GuiProgress(IProgressInfoHandler handler, ProgressType type, IGuiWrapper gui, int x, int y) {
        super(type.getTexture(), gui, x, y, type.getWidth(), type.getHeight());
        this.type = type;
        this.handler = handler;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        if (this.handler.isActive()) {
            GuiProgress.minecraft.field_71446_o.func_110577_a(this.getResource());
            GuiProgress.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.type.getTextureWidth(), (int)this.type.getTextureHeight());
            if (this.type.isVertical()) {
                int displayInt = (int)(this.getProgress() * (double)this.field_230689_k_);
                GuiProgress.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)this.type.getOverlayX(), (float)this.type.getOverlayY(), (int)this.field_230688_j_, (int)displayInt, (int)this.type.getTextureWidth(), (int)this.type.getTextureHeight());
            } else {
                int innerOffsetX = this.type == ProgressType.BAR ? 1 : 0;
                int displayInt = (int)(this.getProgress() * (double)(this.field_230688_j_ - 2 * innerOffsetX));
                GuiProgress.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + innerOffsetX), (int)this.field_230691_m_, (float)(this.type.getOverlayX() + innerOffsetX), (float)this.type.getOverlayY(), (int)displayInt, (int)this.field_230689_k_, (int)this.type.getTextureWidth(), (int)this.type.getTextureHeight());
            }
        }
    }

    protected double getProgress() {
        return Math.min(this.handler.getProgress(), 1.0);
    }

    @Override
    public boolean isActive() {
        return this.handler.isActive();
    }

    @Override
    @Nonnull
    public GuiProgress jeiCategories(ResourceLocation ... recipeCategories) {
        this.recipeCategories = recipeCategories;
        return this;
    }

    @Override
    @Nullable
    public ResourceLocation[] getRecipeCategories() {
        return this.recipeCategories;
    }
}

