/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.common.Mekanism;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.NutritionalLiquifierIRecipe;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismGases;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeRegistryHelper {
    private RecipeRegistryHelper() {
    }

    public static void registerCondensentrator(IRecipeRegistration registry) {
        ArrayList<RotaryRecipe> condensentratorRecipes = new ArrayList<RotaryRecipe>();
        ArrayList<RotaryRecipe> decondensentratorRecipes = new ArrayList<RotaryRecipe>();
        List<RotaryRecipe> recipes = MekanismRecipeType.ROTARY.getRecipes((World)RecipeRegistryHelper.getWorld());
        for (RotaryRecipe recipe : recipes) {
            if (recipe.hasGasToFluid()) {
                condensentratorRecipes.add(recipe);
            }
            if (!recipe.hasFluidToGas()) continue;
            decondensentratorRecipes.add(recipe);
        }
        ResourceLocation condensentrating = Mekanism.rl("rotary_condensentrator_condensentrating");
        ResourceLocation decondensentrating = Mekanism.rl("rotary_condensentrator_decondensentrating");
        registry.addRecipes(condensentratorRecipes, condensentrating);
        registry.addRecipes(decondensentratorRecipes, decondensentrating);
    }

    public static <RECIPE extends MekanismRecipe> void register(IRecipeRegistration registry, IBlockProvider mekanismBlock, MekanismRecipeType<RECIPE> type) {
        RecipeRegistryHelper.register(registry, mekanismBlock.getRegistryName(), type);
    }

    public static <RECIPE extends MekanismRecipe> void register(IRecipeRegistration registry, ResourceLocation id, MekanismRecipeType<RECIPE> type) {
        registry.addRecipes(type.getRecipes((World)RecipeRegistryHelper.getWorld()), id);
    }

    public static void registerNutritionalLiquifier(IRecipeRegistration registry) {
        ArrayList<NutritionalLiquifierIRecipe> list = new ArrayList<NutritionalLiquifierIRecipe>();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            Food food;
            if (!item.func_219971_r() || (food = item.func_219967_s()) == null || food.func_221466_a() <= 0) continue;
            list.add(new NutritionalLiquifierIRecipe(item, ItemStackIngredient.from((IItemProvider)item), MekanismGases.NUTRITIONAL_PASTE.getStack((long)food.func_221466_a() * 50L)));
        }
        registry.addRecipes(list, MekanismBlocks.NUTRITIONAL_LIQUIFIER.getRegistryName());
    }

    public static void registerSPS(IRecipeRegistration registry) {
        GasToGasRecipe recipe = new GasToGasRecipe(Mekanism.rl("processing/polonium_to_antimatter"), GasStackIngredient.from(MekanismGases.POLONIUM, 1000L), MekanismGases.ANTIMATTER.getStack(1L)){

            @Nonnull
            public IRecipeSerializer<?> func_199559_b() {
                return null;
            }

            @Nonnull
            public IRecipeType<?> func_222127_g() {
                return null;
            }
        };
        registry.addRecipes(Collections.singletonList(recipe), MekanismBlocks.SPS_CASING.getRegistryName());
    }

    private static ClientWorld getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

