/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.InfusionStackIngredient;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.custom.GuiCrystallizerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;

public class ChemicalCrystallizerRecipeCategory
extends BaseRecipeCategory<ChemicalCrystallizerRecipe> {
    public ChemicalCrystallizerRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.CHEMICAL_CRYSTALLIZER, 5, 3, 147, 79);
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(new GuiCrystallizerScreen(this, 31, 13, new GuiCrystallizerScreen.IOreInfo(){

            @Override
            @Nonnull
            public BoxedChemicalStack getInputChemical() {
                return BoxedChemicalStack.EMPTY;
            }

            @Override
            @Nullable
            public ChemicalCrystallizerRecipe getRecipe() {
                return null;
            }
        }));
        this.guiElements.add(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 7, 4));
        this.guiElements.add(new GuiSlot(SlotType.EXTRA, this, 7, 64).with(SlotOverlay.PLUS));
        this.guiElements.add(new GuiSlot(SlotType.OUTPUT, this, 128, 56));
        this.guiElements.add(new GuiProgress(() -> (double)this.timer.getValue() / 20.0, ProgressType.LARGE_RIGHT, (IGuiWrapper)this, 53, 61));
    }

    public Class<? extends ChemicalCrystallizerRecipe> getRecipeClass() {
        return ChemicalCrystallizerRecipe.class;
    }

    public void setIngredients(ChemicalCrystallizerRecipe recipe, IIngredients ingredients) {
        IChemicalStackIngredient<?, ?> input = recipe.getInput();
        if (input instanceof GasStackIngredient) {
            ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(((GasStackIngredient)input).getRepresentations()));
        } else if (input instanceof InfusionStackIngredient) {
            ingredients.setInputLists(MekanismJEI.TYPE_INFUSION, Collections.singletonList(((InfusionStackIngredient)input).getRepresentations()));
        } else if (input instanceof PigmentStackIngredient) {
            ingredients.setInputLists(MekanismJEI.TYPE_PIGMENT, Collections.singletonList(((PigmentStackIngredient)input).getRepresentations()));
        } else if (input instanceof SlurryStackIngredient) {
            ingredients.setInputLists(MekanismJEI.TYPE_SLURRY, Collections.singletonList(((SlurryStackIngredient)input).getRepresentations()));
        }
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getOutputDefinition()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, ChemicalCrystallizerRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, false, 128 - this.xOffset, 56 - this.yOffset);
        itemStacks.set(0, recipe.getOutputDefinition());
        IChemicalStackIngredient<?, ?> input = recipe.getInput();
        if (input instanceof GasStackIngredient) {
            this.initChemical(recipeLayout, MekanismJEI.TYPE_GAS, (GasStackIngredient)input);
        } else if (input instanceof InfusionStackIngredient) {
            this.initChemical(recipeLayout, MekanismJEI.TYPE_INFUSION, (InfusionStackIngredient)input);
        } else if (input instanceof PigmentStackIngredient) {
            this.initChemical(recipeLayout, MekanismJEI.TYPE_PIGMENT, (PigmentStackIngredient)input);
        } else if (input instanceof SlurryStackIngredient) {
            this.initChemical(recipeLayout, MekanismJEI.TYPE_SLURRY, (SlurryStackIngredient)input);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void initChemical(IRecipeLayout recipeLayout, IIngredientType<STACK> type, IChemicalStackIngredient<CHEMICAL, STACK> ingredient) {
        IGuiIngredientGroup stacks = recipeLayout.getIngredientsGroup(type);
        this.initChemical(stacks, 0, true, 8 - this.xOffset, 5 - this.yOffset, 16, 58, ingredient.getRepresentations(), true);
    }
}

