/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.baked;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;

public class ExtensionBakedModel<T>
implements IBakedModel {
    protected final IBakedModel original;
    private final LoadingCache<QuadsKey<T>, List<BakedQuad>> cache = CacheBuilder.newBuilder().build(new CacheLoader<QuadsKey<T>, List<BakedQuad>>(){

        public List<BakedQuad> load(@Nonnull QuadsKey<T> key) {
            return ExtensionBakedModel.this.createQuads(key);
        }
    });
    private final Map<List<Pair<IBakedModel, RenderType>>, List<Pair<IBakedModel, RenderType>>> cachedLayerRedirects = new Object2ObjectOpenHashMap();

    public ExtensionBakedModel(IBakedModel original) {
        this.original = original;
    }

    @Nonnull
    @Deprecated
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, @Nonnull Random rand) {
        return this.original.func_200117_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.original.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.original.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.original.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.original.func_188618_c();
    }

    @Nonnull
    @Deprecated
    public TextureAtlasSprite func_177554_e() {
        return this.original.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.original.func_188617_f();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return this.original.handlePerspective(cameraTransformType, mat);
    }

    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.original.func_177552_f();
    }

    public boolean doesHandlePerspectives() {
        return this.original.doesHandlePerspectives();
    }

    protected QuadsKey<T> createKey(QuadsKey<T> key, IModelData data) {
        return key;
    }

    protected List<BakedQuad> createQuads(QuadsKey<T> key) {
        List<BakedQuad> ret = key.getQuads();
        if (key.getTransformation() != null) {
            ret = QuadUtils.transformBakedQuads(ret, key.getTransformation());
        }
        return ret;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        List quads = this.original.getQuads(state, side, rand, data);
        QuadsKey key = this.createKey(new QuadsKey(state, side, rand, MinecraftForgeClient.getRenderLayer(), quads), data);
        if (key == null) {
            return quads;
        }
        return (List)this.cache.getUnchecked(key);
    }

    public boolean isLayered() {
        return this.original.isLayered();
    }

    @Nonnull
    public List<Pair<IBakedModel, RenderType>> getLayerModels(ItemStack stack, boolean fabulous) {
        return this.cachedLayerRedirects.computeIfAbsent(this.original.getLayerModels(stack, fabulous), originalLayerModels -> {
            ArrayList<Pair> layerModels = new ArrayList<Pair>();
            for (Pair layerModel : originalLayerModels) {
                layerModels.add(Pair.of(this.wrapModel((IBakedModel)layerModel.getFirst()), (Object)layerModel.getSecond()));
            }
            return layerModels;
        });
    }

    protected ExtensionBakedModel<T> wrapModel(IBakedModel model) {
        return new ExtensionBakedModel<T>(model);
    }

    public static class QuadsKey<T> {
        private final BlockState state;
        private final Direction side;
        private final Random random;
        private final RenderType layer;
        private final List<BakedQuad> quads;
        private QuadTransformation transformation;
        private T data;
        private int dataHash;
        private BiPredicate<T, T> equality;

        public QuadsKey(BlockState state, Direction side, Random random, RenderType layer, List<BakedQuad> quads) {
            this.state = state;
            this.side = side;
            this.random = random;
            this.layer = layer;
            this.quads = quads;
        }

        public QuadsKey<T> transform(QuadTransformation transformation) {
            this.transformation = transformation;
            return this;
        }

        public QuadsKey<T> data(T data, int dataHash, BiPredicate<T, T> equality) {
            this.data = data;
            this.dataHash = dataHash;
            this.equality = equality;
            return this;
        }

        public BlockState getBlockState() {
            return this.state;
        }

        public Direction getSide() {
            return this.side;
        }

        public Random getRandom() {
            return this.random;
        }

        public RenderType getLayer() {
            return this.layer;
        }

        public List<BakedQuad> getQuads() {
            return this.quads;
        }

        public QuadTransformation getTransformation() {
            return this.transformation;
        }

        public T getData() {
            return this.data;
        }

        public int hashCode() {
            return Objects.hash(this.state, this.side, this.layer, this.transformation, this.dataHash);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof QuadsKey)) {
                return false;
            }
            QuadsKey other = (QuadsKey)obj;
            if (this.side != other.side || !this.state.equals(other.state) || this.layer != other.layer) {
                return false;
            }
            if (this.transformation != null && !this.transformation.equals(other.transformation)) {
                return false;
            }
            return this.data == null || this.equality.test(this.data, other.getData());
        }
    }

    public static class TransformedBakedModel<T>
    extends ExtensionBakedModel<T> {
        private final QuadTransformation transform;

        public TransformedBakedModel(IBakedModel original, QuadTransformation transform) {
            super(original);
            this.transform = transform;
        }

        @Override
        @Nonnull
        @Deprecated
        public List<BakedQuad> func_200117_a(BlockState state, Direction side, @Nonnull Random rand) {
            return QuadUtils.transformBakedQuads(this.original.func_200117_a(state, side, rand), this.transform);
        }

        @Override
        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            this.original.handlePerspective(cameraTransformType, mat);
            return this;
        }

        @Override
        protected QuadsKey<T> createKey(QuadsKey<T> key, IModelData data) {
            return key.transform(this.transform);
        }

        @Override
        protected TransformedBakedModel<T> wrapModel(IBakedModel model) {
            return new TransformedBakedModel<T>(model, this.transform);
        }
    }

    public static class LightedBakedModel
    extends TransformedBakedModel<Void> {
        public LightedBakedModel(IBakedModel original) {
            super(original, QuadTransformation.filtered_fullbright);
        }

        @Override
        protected LightedBakedModel wrapModel(IBakedModel model) {
            return new LightedBakedModel(model);
        }
    }
}

