/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;

@ParametersAreNonnullByDefault
public class RenderPressurizedTube
extends RenderTransmitterBase<TileEntityPressurizedTube> {
    public RenderPressurizedTube(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityPressurizedTube tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        BoxedPressurizedTube tube = tile.getTransmitter();
        if (tube.hasTransmitterNetwork()) {
            BoxedChemicalNetwork network = (BoxedChemicalNetwork)tube.getTransmitterNetwork();
            if (!network.lastChemical.isEmpty() && !network.isTankEmpty() && network.currentScale > 0.0f) {
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.5, 0.5, 0.5);
                Chemical<?> chemical = network.lastChemical.getChemical();
                this.renderModel(tile, matrix, renderer.getBuffer(Atlases.func_228785_j_()), chemical.getTint(), Math.max(0.2f, network.currentScale), 0xF000F0, overlayLight, MekanismRenderer.getChemicalTexture(chemical));
                matrix.func_227865_b_();
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "pressurizedTube";
    }
}

