/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Calendar;
import java.util.Set;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registration.impl.SoundEventRegistryObject;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;

public final class HolidayManager {
    private static final Calendar calendar = Calendar.getInstance();
    private static final Set<Holiday> holidays = new ObjectOpenHashSet();
    public static final Holiday CHRISTMAS = HolidayManager.register(new Christmas());
    public static final Holiday NEW_YEAR = HolidayManager.register(new NewYear());
    public static final Holiday MAY_4 = HolidayManager.register(new May4());
    public static final Holiday APRIL_FOOLS = HolidayManager.register(new AprilFools());

    private static Holiday register(Holiday holiday) {
        holidays.add(holiday);
        return holiday;
    }

    public static void init() {
        if (MekanismConfig.client.holidays.get()) {
            YearlyDate date = HolidayManager.getDate();
            for (Holiday holiday : holidays) {
                if (!holiday.getDate().equals(date)) continue;
                holiday.setIsToday();
            }
            Mekanism.logger.info("Initialized HolidayManager.");
        }
    }

    public static void notify(PlayerEntity player) {
        for (Holiday holiday : holidays) {
            if (!holiday.isToday() || holiday.hasNotified()) continue;
            holiday.notify(player);
        }
    }

    public static SoundEventRegistryObject<SoundEvent> filterSound(SoundEventRegistryObject<SoundEvent> sound) {
        if (!MekanismConfig.client.holidays.get()) {
            return sound;
        }
        for (Holiday holiday : holidays) {
            if (!holiday.isToday()) continue;
            return holiday.filterSound(sound);
        }
        return sound;
    }

    private static YearlyDate getDate() {
        return new YearlyDate(calendar.get(2) + 1, calendar.get(5));
    }

    private static String getThemedLines(EnumColor[] colors, int amount) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < amount; ++i) {
            builder.append(colors[i % colors.length]).append("-");
        }
        return builder.toString();
    }

    public static class YearlyDate {
        public final Month month;
        public final int day;

        public YearlyDate(Month m, int d) {
            this.month = m;
            this.day = d;
        }

        public YearlyDate(int m, int d) {
            this(Month.byIndexStatic(m - 1), d);
        }

        public boolean equals(Object obj) {
            return obj instanceof YearlyDate && ((YearlyDate)obj).month == this.month && ((YearlyDate)obj).day == this.day;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.month.ordinal();
            code = 31 * code + this.day;
            return code;
        }
    }

    public static class AprilFools
    extends Holiday {
        @Override
        public YearlyDate getDate() {
            return new YearlyDate(4, 1);
        }
    }

    public static class May4
    extends Holiday {
        @Override
        public YearlyDate getDate() {
            return new YearlyDate(5, 4);
        }

        @Override
        public void onEvent(PlayerEntity player) {
            String themedLines = HolidayManager.getThemedLines(new EnumColor[]{EnumColor.BLACK, EnumColor.GRAY, EnumColor.BLACK, EnumColor.YELLOW, EnumColor.BLACK}, 15);
            player.func_145747_a((ITextComponent)MekanismLang.HOLIDAY_BORDER.translate(themedLines, EnumColor.DARK_BLUE, MekanismLang.GENERIC_SQUARE_BRACKET.translate(MekanismLang.MEKANISM)), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.MAY_4_LINE_ONE.translateColored(EnumColor.GRAY, EnumColor.DARK_BLUE, player.func_200200_C_()), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.HOLIDAY_BORDER.translate(themedLines, EnumColor.DARK_BLUE, "[=======]"), Util.field_240973_b_);
        }
    }

    public static class NewYear
    extends Holiday {
        @Override
        public YearlyDate getDate() {
            return new YearlyDate(1, 1);
        }

        @Override
        public void onEvent(PlayerEntity player) {
            String themedLines = HolidayManager.getThemedLines(new EnumColor[]{EnumColor.WHITE, EnumColor.YELLOW}, 13);
            player.func_145747_a((ITextComponent)MekanismLang.HOLIDAY_BORDER.translate(themedLines, EnumColor.DARK_BLUE, MekanismLang.GENERIC_SQUARE_BRACKET.translate(MekanismLang.MEKANISM)), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.NEW_YEAR_LINE_ONE.translateColored(EnumColor.AQUA, EnumColor.DARK_BLUE, player.func_200200_C_()), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.NEW_YEAR_LINE_TWO.translateColored(EnumColor.AQUA, new Object[0]), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.NEW_YEAR_LINE_THREE.translateColored(EnumColor.AQUA, calendar.get(1)), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.HOLIDAY_SIGNATURE.translateColored(EnumColor.DARK_GRAY, new Object[0]), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.HOLIDAY_BORDER.translate(themedLines, EnumColor.DARK_BLUE, "[=======]"), Util.field_240973_b_);
        }
    }

    public static class Christmas
    extends Holiday {
        @Override
        public YearlyDate getDate() {
            return new YearlyDate(12, 25);
        }

        @Override
        public void onEvent(PlayerEntity player) {
            String themedLines = HolidayManager.getThemedLines(new EnumColor[]{EnumColor.DARK_GREEN, EnumColor.DARK_RED}, 13);
            player.func_145747_a((ITextComponent)MekanismLang.HOLIDAY_BORDER.translate(themedLines, EnumColor.DARK_BLUE, MekanismLang.GENERIC_SQUARE_BRACKET.translate(MekanismLang.MEKANISM)), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.CHRISTMAS_LINE_ONE.translateColored(EnumColor.RED, EnumColor.DARK_BLUE, player.func_200200_C_()), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.CHRISTMAS_LINE_TWO.translateColored(EnumColor.RED, new Object[0]), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.CHRISTMAS_LINE_THREE.translateColored(EnumColor.RED, new Object[0]), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.CHRISTMAS_LINE_FOUR.translateColored(EnumColor.RED, new Object[0]), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.HOLIDAY_SIGNATURE.translateColored(EnumColor.DARK_GRAY, new Object[0]), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.HOLIDAY_BORDER.translate(themedLines, EnumColor.DARK_BLUE, "[=======]"), Util.field_240973_b_);
        }

        @Override
        public SoundEventRegistryObject<SoundEvent> filterSound(SoundEventRegistryObject<SoundEvent> sound) {
            if (sound == MekanismSounds.ENRICHMENT_CHAMBER) {
                return MekanismSounds.CHRISTMAS1;
            }
            if (sound == MekanismSounds.METALLURGIC_INFUSER) {
                return MekanismSounds.CHRISTMAS2;
            }
            if (sound == MekanismSounds.PURIFICATION_CHAMBER) {
                return MekanismSounds.CHRISTMAS3;
            }
            if (sound == MekanismSounds.ENERGIZED_SMELTER) {
                return MekanismSounds.CHRISTMAS4;
            }
            if (sound == MekanismSounds.CRUSHER) {
                return MekanismSounds.CHRISTMAS5;
            }
            return sound;
        }
    }

    public static abstract class Holiday {
        private boolean hasNotified;
        private boolean isToday;

        public abstract YearlyDate getDate();

        public void onEvent(PlayerEntity player) {
        }

        public SoundEventRegistryObject<SoundEvent> filterSound(SoundEventRegistryObject<SoundEvent> sound) {
            return sound;
        }

        private boolean hasNotified() {
            return this.hasNotified;
        }

        private void notify(PlayerEntity player) {
            this.onEvent(player);
            this.hasNotified = true;
        }

        private void setIsToday() {
            this.isToday = true;
        }

        public boolean isToday() {
            return this.isToday;
        }
    }

    public static enum Month {
        JANUARY("January"),
        FEBRUARY("February"),
        MARCH("March"),
        APRIL("April"),
        MAY("May"),
        JUNE("June"),
        JULY("July"),
        AUGUST("August"),
        SEPTEMBER("September"),
        OCTOBER("October"),
        NOVEMBER("November"),
        DECEMBER("December");

        private static final Month[] MONTHS;
        private final String name;

        private Month(String n2) {
            this.name = n2;
        }

        public String getName() {
            return this.name;
        }

        public int month() {
            return this.ordinal() + 1;
        }

        public static Month byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MONTHS, index);
        }

        static {
            MONTHS = Month.values();
        }
    }
}

