/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CapabilityCache {
    private final Map<Capability<?>, ICapabilityResolver> capabilityResolvers = new HashMap();
    private final List<ICapabilityResolver> uniqueResolvers = new ArrayList<ICapabilityResolver>();
    private final Set<Capability<?>> alwaysDisabled = new HashSet();
    private final Map<Capability<?>, List<BooleanSupplier>> semiDisabled = new HashMap();
    private TileComponentConfig config;

    public void addCapabilityResolver(ICapabilityResolver resolver) {
        this.uniqueResolvers.add(resolver);
        List<Capability<?>> supportedCapabilities = resolver.getSupportedCapabilities();
        for (Capability<?> supportedCapability : supportedCapabilities) {
            if (supportedCapability == null || this.capabilityResolvers.put(supportedCapability, resolver) == null) continue;
            Mekanism.logger.warn("Multiple capability resolvers registered for {}. Overriding", (Object)supportedCapability.getName(), (Object)new Exception());
        }
    }

    public void addDisabledCapabilities(Capability<?> ... capabilities) {
        for (Capability<?> capability : capabilities) {
            if (capability == null) continue;
            this.alwaysDisabled.add(capability);
        }
    }

    public void addDisabledCapabilities(Collection<Capability<?>> capabilities) {
        for (Capability<?> capability : capabilities) {
            if (capability == null) continue;
            this.alwaysDisabled.add(capability);
        }
    }

    public void addSemiDisabledCapability(Capability<?> capability, BooleanSupplier checker) {
        if (capability != null) {
            this.semiDisabled.computeIfAbsent(capability, cap -> new ArrayList()).add(checker);
        }
    }

    public void addConfigComponent(TileComponentConfig config) {
        if (this.config != null) {
            Mekanism.logger.warn("Config component already registered. Overriding", (Throwable)new Exception());
        }
        this.config = config;
    }

    public boolean isCapabilityDisabled(Capability<?> capability, @Nullable Direction side) {
        if (this.alwaysDisabled.contains(capability)) {
            return true;
        }
        if (this.semiDisabled.containsKey(capability)) {
            List<BooleanSupplier> predicates = this.semiDisabled.get(capability);
            for (BooleanSupplier predicate : predicates) {
                if (!predicate.getAsBoolean()) continue;
                return true;
            }
        }
        if (this.config == null) {
            return false;
        }
        return this.config.isCapabilityDisabled(capability, side);
    }

    public boolean canResolve(Capability<?> capability) {
        return this.capabilityResolvers.containsKey(capability);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (!this.isCapabilityDisabled(capability, side) && this.canResolve(capability)) {
            return this.getCapabilityUnchecked(capability, side);
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getCapabilityUnchecked(Capability<T> capability, @Nullable Direction side) {
        ICapabilityResolver capabilityResolver = this.capabilityResolvers.get(capability);
        if (capabilityResolver == null) {
            return LazyOptional.empty();
        }
        return capabilityResolver.resolve(capability, side);
    }

    public void invalidate(Capability<?> capability, @Nullable Direction side) {
        ICapabilityResolver capabilityResolver = this.capabilityResolvers.get(capability);
        if (capabilityResolver != null) {
            capabilityResolver.invalidate(capability, side);
        }
    }

    public void invalidateAll() {
        this.uniqueResolvers.forEach(ICapabilityResolver::invalidateAll);
    }
}

