/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import mekanism.api.functions.FloatSupplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedPrimitiveValue;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedFloatValue
extends CachedPrimitiveValue<Double>
implements FloatSupplier {
    private float cachedValue;

    private CachedFloatValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<Double> internal) {
        super(config, internal);
    }

    public static CachedFloatValue wrap(IMekanismConfig config, ForgeConfigSpec.ConfigValue<Double> internal) {
        return new CachedFloatValue(config, internal);
    }

    public float get() {
        if (!this.resolved) {
            Double val = (Double)this.internal.get();
            this.cachedValue = val == null ? 0.0f : (val > 3.4028234663852886E38 ? Float.MAX_VALUE : (val < -3.4028234663852886E38 ? -3.4028235E38f : val.floatValue()));
            this.resolved = true;
        }
        return this.cachedValue;
    }

    @Override
    public float getAsFloat() {
        return this.get();
    }

    public void set(float value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }
}

