/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.filter;

import javax.annotation.Nullable;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerItemStackFilter;
import mekanism.common.content.miner.MinerMaterialFilter;
import mekanism.common.content.miner.MinerModIDFilter;
import mekanism.common.content.miner.MinerTagFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.content.transporter.SorterMaterialFilter;
import mekanism.common.content.transporter.SorterModIDFilter;
import mekanism.common.content.transporter.SorterTagFilter;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public abstract class BaseFilter<FILTER extends BaseFilter<FILTER>>
implements IFilter<FILTER> {
    @Override
    public abstract FILTER clone();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        nbtTags.func_74768_a("type", this.getFilterType().ordinal());
        return nbtTags;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.getFilterType());
    }

    @Nullable
    public static IFilter<?> readFromNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("type", 3)) {
            IFilter<?> filter = BaseFilter.fromType(FilterType.byIndexStatic(nbt.func_74762_e("type")));
            if (filter != null) {
                filter.read(nbt);
            }
            return filter;
        }
        return null;
    }

    @Nullable
    public static IFilter<?> readFromPacket(PacketBuffer dataStream) {
        IFilter<?> filter = BaseFilter.fromType((FilterType)dataStream.func_179257_a(FilterType.class));
        if (filter != null) {
            filter.read(dataStream);
        }
        return filter;
    }

    private static IFilter<?> fromType(FilterType filterType) {
        switch (filterType) {
            case MINER_ITEMSTACK_FILTER: {
                return new MinerItemStackFilter();
            }
            case MINER_MATERIAL_FILTER: {
                return new MinerMaterialFilter();
            }
            case MINER_MODID_FILTER: {
                return new MinerModIDFilter();
            }
            case MINER_TAG_FILTER: {
                return new MinerTagFilter();
            }
            case SORTER_ITEMSTACK_FILTER: {
                return new SorterItemStackFilter();
            }
            case SORTER_MATERIAL_FILTER: {
                return new SorterMaterialFilter();
            }
            case SORTER_MODID_FILTER: {
                return new SorterModIDFilter();
            }
            case SORTER_TAG_FILTER: {
                return new SorterTagFilter();
            }
            case OREDICTIONIFICATOR: {
                return new TileEntityOredictionificator.OredictionificatorFilter();
            }
            case QIO_ITEMSTACK_FILTER: {
                return new QIOItemStackFilter();
            }
            case QIO_TAG_FILTER: {
                return new QIOTagFilter();
            }
        }
        return null;
    }
}

