/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.mekasuit.ModuleMekaSuit;
import mekanism.common.content.network.distribution.EnergySaveTarget;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;

public class ModuleChargeDistributionUnit
extends ModuleMekaSuit {
    private ModuleConfigItem<Boolean> chargeSuit;
    private ModuleConfigItem<Boolean> chargeInventory;

    @Override
    public void init() {
        super.init();
        this.chargeSuit = this.addConfigItem(new ModuleConfigItem<Boolean>(this, "charge_suit", MekanismLang.MODULE_CHARGE_SUIT, new ModuleConfigItem.BooleanData(), true));
        this.chargeInventory = this.addConfigItem(new ModuleConfigItem<Boolean>(this, "charge_inventory", MekanismLang.MODULE_CHARGE_INVENTORY, new ModuleConfigItem.BooleanData(), false));
    }

    @Override
    public void tickServer(PlayerEntity player) {
        super.tickServer(player);
        if (this.chargeInventory.get().booleanValue()) {
            this.chargeInventory(player);
        }
        if (this.chargeSuit.get().booleanValue()) {
            this.chargeSuit(player);
        }
    }

    private void chargeSuit(PlayerEntity player) {
        ObjectOpenHashSet saveTargets = new ObjectOpenHashSet();
        FloatingLong total = FloatingLong.ZERO;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
            if (energyContainer == null) continue;
            EnergySaveTarget saveTarget = new EnergySaveTarget();
            saveTarget.addHandler(Direction.NORTH, energyContainer);
            saveTargets.add(saveTarget);
            total = total.plusEqual(energyContainer.getEnergy());
        }
        EmitUtils.sendToAcceptors(saveTargets, saveTargets.size(), total.copy());
        for (EnergySaveTarget saveTarget : saveTargets) {
            saveTarget.save(Direction.NORTH);
        }
    }

    private void chargeInventory(PlayerEntity player) {
        FloatingLong toCharge = (FloatingLong)MekanismConfig.gear.mekaSuitInventoryChargeRate.get();
        toCharge = this.charge(player, player.func_184614_ca(), toCharge);
        toCharge = this.charge(player, player.func_184592_cb(), toCharge);
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == player.func_184614_ca() || stack == player.func_184592_cb()) continue;
            if (toCharge.isZero()) break;
            toCharge = this.charge(player, stack, toCharge);
        }
    }

    private FloatingLong charge(PlayerEntity player, ItemStack stack, FloatingLong amount) {
        FloatingLong remaining;
        IStrictEnergyHandler handler = EnergyCompatUtils.getStrictEnergyHandler(stack);
        if (handler != null && (remaining = handler.insertEnergy(amount, Action.SIMULATE)).smallerThan(amount)) {
            return handler.insertEnergy(this.useEnergy((LivingEntity)player, amount.subtract(remaining), false), Action.EXECUTE).add(remaining);
        }
        return amount;
    }
}

