/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.mekatool.ModuleMekaTool;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ModuleExcavationEscalationUnit
extends ModuleMekaTool {
    private ModuleConfigItem<ExcavationMode> excavationMode;

    @Override
    public void init() {
        super.init();
        this.excavationMode = new ModuleConfigItem<ExcavationMode>(this, "excavation_mode", MekanismLang.MODULE_EFFICIENCY, new ModuleConfigItem.EnumData<ExcavationMode>(ExcavationMode.class, this.getInstalledCount() + 2), ExcavationMode.NORMAL);
        this.addConfigItem(this.excavationMode);
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        if (!this.isEnabled()) {
            return;
        }
        ExcavationMode newMode = (ExcavationMode)this.excavationMode.get().adjust(shift);
        if (this.excavationMode.get() != newMode) {
            this.excavationMode.set(newMode, null);
            if (displayChangeMessage) {
                this.displayModeChange(player, (ITextComponent)MekanismLang.MODULE_EFFICIENCY.translate(new Object[0]), newMode);
            }
        }
    }

    @Override
    public void addHUDStrings(List<ITextComponent> list) {
        if (!this.isEnabled()) {
            return;
        }
        list.add((ITextComponent)MekanismLang.DISASSEMBLER_EFFICIENCY.translateColored(EnumColor.DARK_GRAY, EnumColor.INDIGO, this.excavationMode.get().getEfficiency()));
    }

    public double getEfficiency() {
        return this.excavationMode.get().getEfficiency();
    }

    public static enum ExcavationMode implements IIncrementalEnum<ExcavationMode>,
    IHasTextComponent
    {
        OFF(0),
        SLOW(4),
        NORMAL(16),
        FAST(32),
        SUPER_FAST(64),
        EXTREME(128);

        private static final ExcavationMode[] MODES;
        private final ITextComponent label;
        private final int efficiency;

        private ExcavationMode(int efficiency) {
            this.efficiency = efficiency;
            this.label = new StringTextComponent(Integer.toString(efficiency));
        }

        @Override
        @Nonnull
        public ExcavationMode byIndex(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.label;
        }

        public int getEfficiency() {
            return this.efficiency;
        }

        static {
            MODES = ExcavationMode.values();
        }
    }
}

