/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.mekatool.ModuleMekaTool;
import mekanism.common.network.PacketLightningRender;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ModuleVeinMiningUnit
extends ModuleMekaTool {
    private ModuleConfigItem<Boolean> extendedMode;
    private ModuleConfigItem<ExcavationRange> excavationRange;

    @Override
    public void init() {
        super.init();
        this.extendedMode = new ModuleConfigItem.DisableableModuleConfigItem((Module)this, "extended_mode", (ILangEntry)MekanismLang.MODULE_EXTENDED_MODE, false, MekanismConfig.gear.mekaToolExtendedMining);
        this.addConfigItem(this.extendedMode);
        this.excavationRange = new ModuleConfigItem<ExcavationRange>(this, "excavation_range", MekanismLang.MODULE_EXCAVATION_RANGE, new ModuleConfigItem.EnumData<ExcavationRange>(ExcavationRange.class, this.getInstalledCount() + 1), ExcavationRange.LOW);
        this.addConfigItem(this.excavationRange);
    }

    public boolean isExtended() {
        return this.extendedMode.get();
    }

    public int getExcavationRange() {
        return this.excavationRange.get().getRange();
    }

    public static Set<BlockPos> findPositions(BlockState state, BlockPos location, World world, int maxRange) {
        LinkedHashSet<BlockPos> found = new LinkedHashSet<BlockPos>();
        LinkedHashSet<BlockPos> openSet = new LinkedHashSet<BlockPos>();
        openSet.add(location);
        Block startBlock = state.func_177230_c();
        int maxCount = MekanismConfig.gear.disassemblerMiningCount.get() - 1;
        while (!openSet.isEmpty()) {
            BlockPos blockPos = (BlockPos)openSet.iterator().next();
            found.add(blockPos);
            openSet.remove(blockPos);
            if (found.size() > maxCount) {
                return found;
            }
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)blockPos.func_177982_a(-1, -1, -1), (BlockPos)blockPos.func_177982_a(1, 1, 1))) {
                Optional<BlockState> blockState;
                if (found.contains(pos) || maxRange != -1 && !(WorldUtils.distanceBetween(location, pos) <= (double)maxRange) || !(blockState = WorldUtils.getBlockState((IBlockReader)world, pos)).isPresent() || startBlock != blockState.get().func_177230_c() || !openSet.add(pos.func_185334_h())) continue;
                Mekanism.packetHandler.sendToAllTracking(new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, Objects.hash(blockPos, pos), Vector3d.func_237489_a_((Vector3i)blockPos), Vector3d.func_237489_a_((Vector3i)pos), 10), world, blockPos);
            }
        }
        return found;
    }

    @Override
    public void addHUDStrings(List<ITextComponent> list) {
        if (!this.isEnabled()) {
            return;
        }
        if (MekanismConfig.gear.mekaToolExtendedMining.getAsBoolean()) {
            list.add((ITextComponent)MekanismLang.MODULE_EXTENDED_ENABLED.translateColored(EnumColor.DARK_GRAY, this.isExtended() ? EnumColor.BRIGHT_GREEN : EnumColor.DARK_RED, this.isExtended() ? MekanismLang.MODULE_ENABLED_LOWER : MekanismLang.MODULE_DISABLED_LOWER));
        }
    }

    public static enum ExcavationRange implements IHasTextComponent
    {
        OFF(0),
        LOW(2),
        MED(4),
        HIGH(6),
        EXTREME(8);

        private final int range;
        private final ITextComponent label;

        private ExcavationRange(int range) {
            this.range = range;
            this.label = new StringTextComponent(Integer.toString(range));
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.label;
        }

        public int getRange() {
            return this.range;
        }
    }
}

