/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.distribution;

import mekanism.api.math.FloatingLong;
import mekanism.common.content.network.transmitter.UniversalCable;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;
import net.minecraft.util.Direction;

public class EnergyTransmitterSaveTarget
extends Target<UniversalCable, FloatingLong, FloatingLong> {
    private FloatingLong currentStored = FloatingLong.ZERO;

    @Override
    protected void acceptAmount(UniversalCable transmitter, SplitInfo<FloatingLong> splitInfo, FloatingLong amount) {
        amount = amount.min(transmitter.getCapacityAsFloatingLong().subtract(this.currentStored));
        this.currentStored = this.currentStored.plusEqual(amount);
        splitInfo.send(amount);
    }

    @Override
    protected FloatingLong simulate(UniversalCable transmitter, FloatingLong energyToSend) {
        return energyToSend.copy().min(transmitter.getCapacityAsFloatingLong().subtract(this.currentStored));
    }

    public void saveShare(Direction handlerDirection) {
        UniversalCable cable = (UniversalCable)this.handlers.get(handlerDirection);
        if (!this.currentStored.isZero() || !cable.lastWrite.isZero()) {
            cable.lastWrite = this.currentStored;
            cable.getTransmitterTile().markDirty(false);
        }
    }
}

