/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.item.PortableQIODashboardContainer;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemPortableQIODashboard
extends Item
implements IFrequencyItem,
IGuiItem {
    public ItemPortableQIODashboard(Item.Properties properties) {
        super(properties.func_200917_a(1).func_208103_a(Rarity.RARE));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getOwnerUUID(stack) == null) {
            if (!world.field_72995_K) {
                SecurityUtils.claimItem(player, stack);
            }
        } else if (SecurityUtils.canAccess(player, stack)) {
            if (!world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.getContainerProvider(stack, hand), buf -> {
                    buf.func_179249_a((Enum)hand);
                    buf.func_150788_a(stack);
                });
            }
        } else {
            SecurityUtils.displayNoAccess(player);
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public INamedContainerProvider getContainerProvider(ItemStack stack, Hand hand) {
        return new ContainerProvider(stack.func_200301_q(), (i, inv, p) -> new PortableQIODashboardContainer(i, inv, hand, stack));
    }

    @Override
    public void setFrequency(ItemStack stack, Frequency frequency) {
        IFrequencyItem.super.setFrequency(stack, frequency);
        this.setColor(stack, frequency != null ? ((QIOFrequency)frequency).getColor() : null);
    }

    public EnumColor getColor(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "color", 3)) {
            return EnumColor.byIndexStatic(ItemDataUtils.getInt(stack, "color"));
        }
        return null;
    }

    public void setColor(ItemStack stack, EnumColor color) {
        if (color == null) {
            ItemDataUtils.removeData(stack, "color");
        } else {
            ItemDataUtils.setInt(stack, "color", color.ordinal());
        }
    }
}

