/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.basic.BlockBin;
import mekanism.common.inventory.BinMekanismInventory;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.tier.BinTier;
import mekanism.common.util.text.TextUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemBlockBin
extends ItemBlockTooltip<BlockBin>
implements IItemSustainedInventory {
    public ItemBlockBin(BlockBin block) {
        super(block, ItemDeferredRegister.getMekBaseProperties().func_200917_a(1));
    }

    @Override
    public BinTier getTier() {
        return Attribute.getTier(this.func_179223_d(), BinTier.class);
    }

    @Override
    public void addStats(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, boolean advanced) {
        BinMekanismInventory inventory = BinMekanismInventory.create(stack);
        BinTier tier = this.getTier();
        if (inventory != null && tier != null) {
            BinInventorySlot slot = inventory.getBinSlot();
            if (slot.isEmpty()) {
                tooltip.add((ITextComponent)MekanismLang.EMPTY.translateColored(EnumColor.DARK_RED, new Object[0]));
            } else {
                tooltip.add((ITextComponent)TextComponentUtil.build(EnumColor.BRIGHT_GREEN, slot.getStack().func_200301_q()));
                if (tier == BinTier.CREATIVE) {
                    tooltip.add((ITextComponent)MekanismLang.ITEM_AMOUNT.translateColored(EnumColor.PURPLE, EnumColor.GRAY, MekanismLang.INFINITE));
                } else {
                    tooltip.add((ITextComponent)MekanismLang.ITEM_AMOUNT.translateColored(EnumColor.PURPLE, EnumColor.GRAY, TextUtils.format(slot.getCount())));
                }
            }
            if (tier == BinTier.CREATIVE) {
                tooltip.add((ITextComponent)MekanismLang.CAPACITY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, MekanismLang.INFINITE));
            } else {
                tooltip.add((ITextComponent)MekanismLang.CAPACITY_ITEMS.translateColored(EnumColor.INDIGO, EnumColor.GRAY, TextUtils.format(tier.getStorage())));
            }
        }
    }
}

