/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.item.interfaces.IModeItem;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketModeChange {
    private final boolean displayChangeMessage;
    private final EquipmentSlotType slot;
    private final int shift;

    public PacketModeChange(EquipmentSlotType slot, boolean holdingShift) {
        this(slot, holdingShift ? -1 : 1, true);
    }

    public PacketModeChange(EquipmentSlotType slot, int shift) {
        this(slot, shift, false);
    }

    public PacketModeChange(EquipmentSlotType slot, int shift, boolean displayChangeMessage) {
        this.slot = slot;
        this.shift = shift;
        this.displayChangeMessage = displayChangeMessage;
    }

    public static void handle(PacketModeChange message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ItemStack stack;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && !(stack = player.func_184582_a(message.slot)).func_190926_b() && stack.func_77973_b() instanceof IModeItem) {
                ((IModeItem)stack.func_77973_b()).changeMode((PlayerEntity)player, stack, message.shift, message.displayChangeMessage);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketModeChange pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.slot);
        buf.func_150787_b(pkt.shift);
        buf.writeBoolean(pkt.displayChangeMessage);
    }

    public static PacketModeChange decode(PacketBuffer buf) {
        return new PacketModeChange((EquipmentSlotType)buf.func_179257_a(EquipmentSlotType.class), buf.func_150792_a(), buf.readBoolean());
    }
}

