/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.content.gear.Modules;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.tile.TileEntityModificationStation;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRemoveModule {
    private final BlockPos pos;
    private final Modules.ModuleData<?> moduleType;

    public PacketRemoveModule(BlockPos pos, Modules.ModuleData<?> type) {
        this.pos = pos;
        this.moduleType = type;
    }

    public static void handle(PacketRemoveModule message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TileEntityModificationStation tile;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && (tile = WorldUtils.getTileEntity(TileEntityModificationStation.class, (IBlockReader)player.field_70170_p, message.pos)) != null) {
                tile.removeModule((PlayerEntity)player, message.moduleType);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketRemoveModule pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.func_180714_a(pkt.moduleType.getName());
    }

    public static PacketRemoveModule decode(PacketBuffer buf) {
        return new PacketRemoveModule(buf.func_179259_c(), Modules.get(BasePacketHandler.readString(buf)));
    }
}

