/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.config.value.CachedIntValue;

public enum FluidTankTier implements ITier
{
    BASIC(BaseTier.BASIC, 14000, 400),
    ADVANCED(BaseTier.ADVANCED, 28000, 800),
    ELITE(BaseTier.ELITE, 56000, 1600),
    ULTIMATE(BaseTier.ULTIMATE, 112000, 3200),
    CREATIVE(BaseTier.CREATIVE, Integer.MAX_VALUE, 0x3FFFFFFF);

    private final int baseStorage;
    private final int baseOutput;
    private final BaseTier baseTier;
    private CachedIntValue storageReference;
    private CachedIntValue outputReference;

    private FluidTankTier(BaseTier tier, int s, int o) {
        this.baseStorage = s;
        this.baseOutput = o;
        this.baseTier = tier;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public int getStorage() {
        return this.storageReference == null ? this.getBaseStorage() : this.storageReference.get();
    }

    public int getOutput() {
        return this.outputReference == null ? this.getBaseOutput() : this.outputReference.get();
    }

    public int getBaseStorage() {
        return this.baseStorage;
    }

    public int getBaseOutput() {
        return this.baseOutput;
    }

    public void setConfigReference(CachedIntValue storageReference, CachedIntValue outputReference) {
        this.storageReference = storageReference;
        this.outputReference = outputReference;
    }
}

