/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IIncrementalEnum;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.chemical.ChemicalTankChemicalTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.slot.chemical.MergedChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.upgrade.ChemicalTankUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;

public class TileEntityChemicalTank
extends TileEntityMekanism
implements ISideConfiguration,
ISustainedData,
IHasGasMode {
    public final TileComponentEjector ejectorComponent;
    public final TileComponentConfig configComponent;
    public GasMode dumping = GasMode.IDLE;
    private MergedChemicalTank chemicalTank;
    private ChemicalTankTier tier;
    private MergedChemicalInventorySlot<MergedChemicalTank> drainSlot;
    private MergedChemicalInventorySlot<MergedChemicalTank> fillSlot;

    public TileEntityChemicalTank(IBlockProvider blockProvider) {
        super(blockProvider);
        this.configComponent = new TileComponentConfig(this, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY, TransmissionType.ITEM);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, this.drainSlot, this.fillSlot, RelativeSide.FRONT, true).setCanEject(false);
        this.configComponent.setupIOConfig(TransmissionType.GAS, this.getGasTank(), this.getGasTank(), RelativeSide.FRONT).setEjecting(true);
        this.configComponent.setupIOConfig(TransmissionType.INFUSION, this.getInfusionTank(), this.getInfusionTank(), RelativeSide.FRONT).setEjecting(true);
        this.configComponent.setupIOConfig(TransmissionType.PIGMENT, this.getPigmentTank(), this.getPigmentTank(), RelativeSide.FRONT).setEjecting(true);
        this.configComponent.setupIOConfig(TransmissionType.SLURRY, this.getSlurryTank(), this.getSlurryTank(), RelativeSide.FRONT).setEjecting(true);
        this.ejectorComponent = new TileComponentEjector(this);
    }

    @Override
    protected void presetVariables() {
        this.tier = Attribute.getTier(this.getBlockType(), ChemicalTankTier.class);
        this.chemicalTank = ChemicalTankChemicalTank.create(this.tier, this);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        builder.addTank(this.getGasTank());
        return builder.build();
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks() {
        ChemicalTankHelper<InfuseType, InfusionStack, IInfusionTank> builder = ChemicalTankHelper.forSideInfusionWithConfig(this::getDirection, this::getConfig);
        builder.addTank(this.getInfusionTank());
        return builder.build();
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> getInitialPigmentTanks() {
        ChemicalTankHelper<Pigment, PigmentStack, IPigmentTank> builder = ChemicalTankHelper.forSidePigmentWithConfig(this::getDirection, this::getConfig);
        builder.addTank(this.getPigmentTank());
        return builder.build();
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> getInitialSlurryTanks() {
        ChemicalTankHelper<Slurry, SlurryStack, ISlurryTank> builder = ChemicalTankHelper.forSideSlurryWithConfig(this::getDirection, this::getConfig);
        builder.addTank(this.getSlurryTank());
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.drainSlot = MergedChemicalInventorySlot.drain(this.chemicalTank, this, 16, 16);
        builder.addSlot(this.drainSlot);
        this.fillSlot = MergedChemicalInventorySlot.fill(this.chemicalTank, this, 16, 48);
        builder.addSlot(this.fillSlot);
        this.drainSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.drainSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.fillSlot.setSlotType(ContainerSlotType.INPUT);
        this.fillSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.drainSlot.drainChemicalTanks();
        this.fillSlot.fillChemicalTanks();
        MergedChemicalTank.Current current = this.chemicalTank.getCurrent();
        if (current != MergedChemicalTank.Current.EMPTY) {
            IChemicalTank<?, ?> currentTank = null;
            if (MekanismUtils.canFunction(this) && (this.tier == ChemicalTankTier.CREATIVE || this.dumping != GasMode.DUMPING)) {
                currentTank = this.getCurrentTank(current);
                if (current == MergedChemicalTank.Current.GAS) {
                    this.doAutoEject(TransmissionType.GAS, currentTank);
                } else if (current == MergedChemicalTank.Current.INFUSION) {
                    this.doAutoEject(TransmissionType.INFUSION, currentTank);
                } else if (current == MergedChemicalTank.Current.PIGMENT) {
                    this.doAutoEject(TransmissionType.PIGMENT, currentTank);
                } else if (current == MergedChemicalTank.Current.SLURRY) {
                    this.doAutoEject(TransmissionType.SLURRY, currentTank);
                }
            }
            if (this.tier != ChemicalTankTier.CREATIVE) {
                long needed;
                if (this.dumping == GasMode.DUMPING) {
                    this.getCurrentTank(currentTank, current).shrinkStack(this.tier.getStorage() / 400L, Action.EXECUTE);
                } else if (this.dumping == GasMode.DUMPING_EXCESS && (needed = (currentTank = this.getCurrentTank(currentTank, current)).getNeeded()) < this.tier.getOutput()) {
                    currentTank.shrinkStack(this.tier.getOutput() - needed, Action.EXECUTE);
                }
            }
        }
    }

    private IChemicalTank<?, ?> getCurrentTank(IChemicalTank<?, ?> currentTank, MergedChemicalTank.Current current) {
        if (currentTank == null) {
            return this.getCurrentTank(current);
        }
        return currentTank;
    }

    private IChemicalTank<?, ?> getCurrentTank(MergedChemicalTank.Current current) {
        if (current == MergedChemicalTank.Current.GAS) {
            return this.getGasTank();
        }
        if (current == MergedChemicalTank.Current.INFUSION) {
            return this.getInfusionTank();
        }
        if (current == MergedChemicalTank.Current.PIGMENT) {
            return this.getPigmentTank();
        }
        if (current == MergedChemicalTank.Current.SLURRY) {
            return this.getSlurryTank();
        }
        throw new IllegalStateException("Unknown chemical type");
    }

    private void doAutoEject(TransmissionType type, IChemicalTank<?, ?> tank) {
        ConfigInfo config = this.configComponent.getConfig(type);
        if (config != null && config.isEjecting()) {
            ChemicalUtil.emit(config.getAllOutputtingSides(), tank, this, this.tier.getOutput());
        }
    }

    @Override
    public void nextMode(int tank) {
        if (tank == 0) {
            this.dumping = (GasMode)this.dumping.getNext();
            this.markDirty(false);
        }
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "dumping", GasMode::byIndexStatic, mode -> {
            this.dumping = mode;
        });
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("dumping", this.dumping.ordinal());
        return nbtTags;
    }

    @Override
    protected void dumpRadiation() {
        if (this.tier != ChemicalTankTier.CREATIVE) {
            super.dumpRadiation();
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.getStoredAmount(), this.tier.getStorage());
    }

    private long getStoredAmount() {
        switch (this.chemicalTank.getCurrent()) {
            case GAS: {
                return this.getGasTank().getStored();
            }
            case INFUSION: {
                return this.getInfusionTank().getStored();
            }
            case PIGMENT: {
                return this.getPigmentTank().getStored();
            }
            case SLURRY: {
                return this.getSlurryTank().getStored();
            }
        }
        return 0L;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public Direction getOrientation() {
        return this.getDirection();
    }

    public ChemicalTankTier getTier() {
        return this.tier;
    }

    public MergedChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }

    public IGasTank getGasTank() {
        return this.chemicalTank.getGasTank();
    }

    public IInfusionTank getInfusionTank() {
        return this.chemicalTank.getInfusionTank();
    }

    public IPigmentTank getPigmentTank() {
        return this.chemicalTank.getPigmentTank();
    }

    public ISlurryTank getSlurryTank() {
        return this.chemicalTank.getSlurryTank();
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof ChemicalTankUpgradeData) {
            ChemicalTankUpgradeData data = (ChemicalTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.drainSlot.setStack(data.drainSlot.getStack());
            this.fillSlot.setStack(data.fillSlot.getStack());
            this.dumping = data.dumping;
            this.getGasTank().setStack(data.storedGas);
            this.getInfusionTank().setStack(data.storedInfusion);
            this.getPigmentTank().setStack(data.storedPigment);
            this.getSlurryTank().setStack(data.storedSlurry);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public ChemicalTankUpgradeData getUpgradeData() {
        return new ChemicalTankUpgradeData(this.redstone, this.getControlType(), this.drainSlot, this.fillSlot, this.dumping, (GasStack)this.getGasTank().getStack(), (InfusionStack)this.getInfusionTank().getStack(), (PigmentStack)this.getPigmentTank().getStack(), (SlurryStack)this.getSlurryTank().getStack(), this.getComponents());
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setInt(itemStack, "dumping", this.dumping.ordinal());
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.dumping = GasMode.byIndexStatic(ItemDataUtils.getInt(itemStack, "dumping"));
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("dumping", "dumping");
        return remap;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableEnum.create(GasMode::byIndexStatic, GasMode.IDLE, () -> this.dumping, value -> {
            this.dumping = value;
        }));
    }

    public static enum GasMode implements IIncrementalEnum<GasMode>,
    IHasTextComponent
    {
        IDLE(MekanismLang.IDLE),
        DUMPING_EXCESS(MekanismLang.DUMPING_EXCESS),
        DUMPING(MekanismLang.DUMPING);

        private static final GasMode[] MODES;
        private final ILangEntry langEntry;

        private GasMode(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        @Override
        @Nonnull
        public GasMode byIndex(int index) {
            return GasMode.byIndexStatic(index);
        }

        public static GasMode byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = GasMode.values();
        }
    }
}

