/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackToItemStackCachedRecipe;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tile.factory.TileEntityItemToItemFactory;
import mekanism.common.upgrade.MachineUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;

public class TileEntityItemStackToItemStackFactory
extends TileEntityItemToItemFactory<ItemStackToItemStackRecipe> {
    public TileEntityItemStackToItemStackFactory(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    public boolean isValidInputItem(@Nonnull ItemStack stack) {
        return this.containsRecipe(recipe -> recipe.getInput().testType(stack));
    }

    @Override
    protected int getNeededInput(ItemStackToItemStackRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt(recipe.getInput().getNeededAmount(inputStack));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ItemStackToItemStackRecipe> cached, @Nonnull ItemStack stack) {
        return cached != null && cached.getRecipe().getInput().testType(stack);
    }

    @Override
    protected ItemStackToItemStackRecipe findRecipe(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        ItemStack output = outputSlot.getStack();
        return (ItemStackToItemStackRecipe)this.findFirstRecipe(recipe -> recipe.getInput().testType(fallbackInput) && InventoryUtils.areItemsStackable(recipe.getOutput(fallbackInput), output));
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ItemStackToItemStackRecipe> getRecipeType() {
        switch (this.field_200663_e) {
            case ENRICHING: {
                return MekanismRecipeType.ENRICHING;
            }
            case CRUSHING: {
                return MekanismRecipeType.CRUSHING;
            }
        }
        return MekanismRecipeType.SMELTING;
    }

    @Override
    @Nullable
    public ItemStackToItemStackRecipe getRecipe(int cacheIndex) {
        ItemStack stack = (ItemStack)this.inputHandlers[cacheIndex].getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        return (ItemStackToItemStackRecipe)this.findFirstRecipe(recipe -> recipe.test(stack));
    }

    @Override
    public CachedRecipe<ItemStackToItemStackRecipe> createNewCachedRecipe(@Nonnull ItemStackToItemStackRecipe recipe, int cacheIndex) {
        return new ItemStackToItemStackCachedRecipe(recipe, this.inputHandlers[cacheIndex], this.outputHandlers[cacheIndex]).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    @Nonnull
    public MachineUpgradeData getUpgradeData() {
        return new MachineUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }
}

