/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import mekanism.api.heat.HeatAPI;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.FuelInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeHooks;

public class TileEntityFuelwoodHeater
extends TileEntityMekanism {
    public int burnTime;
    public int maxBurnTime;
    public double lastEnvironmentLoss;
    private FuelInventorySlot fuelSlot;
    private BasicHeatCapacitor heatCapacitor;

    public TileEntityFuelwoodHeater() {
        super(MekanismBlocks.FUELWOOD_HEATER);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.fuelSlot = FuelInventorySlot.forFuel(ForgeHooks::getBurnTime, this, 15, 29);
        builder.addSlot(this.fuelSlot);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(this::getDirection);
        this.heatCapacitor = BasicHeatCapacitor.create(100.0, 5.0, 10.0, this);
        builder.addCapacitor(this.heatCapacitor);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        boolean burning = false;
        if (this.burnTime > 0) {
            --this.burnTime;
            burning = true;
        } else {
            this.maxBurnTime = this.burnTime = this.fuelSlot.burn();
            if (this.burnTime > 0) {
                burning = true;
            }
        }
        if (burning) {
            this.heatCapacitor.handleHeat(MekanismConfig.general.heatPerFuelTick.get());
        }
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastEnvironmentLoss = loss.getEnvironmentTransfer();
        this.setActive(burning);
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        this.burnTime = nbtTags.func_74762_e("burnTime");
        this.maxBurnTime = nbtTags.func_74762_e("maxBurnTime");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("burnTime", this.burnTime);
        nbtTags.func_74768_a("maxBurnTime", this.maxBurnTime);
        return nbtTags;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableInt.create(() -> this.burnTime, value -> {
            this.burnTime = value;
        }));
        container.track(SyncableInt.create(() -> this.maxBurnTime, value -> {
            this.maxBurnTime = value;
        }));
        container.track(SyncableDouble.create(() -> this.lastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }
}

