/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.Pair;

public final class MultipartUtils {
    private MultipartUtils() {
    }

    public static Pair<Vector3d, Vector3d> getRayTraceVectors(Entity entity) {
        float pitch = entity.field_70125_A;
        float yaw = entity.field_70177_z;
        Vector3d start = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        float f1 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = f2 * f3;
        float f6 = f1 * f3;
        double d3 = 5.0;
        if (entity instanceof PlayerEntity) {
            d3 = ((PlayerEntity)entity).func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        }
        Vector3d end = start.func_72441_c((double)f5 * d3, (double)f4 * d3, (double)f6 * d3);
        return Pair.of((Object)start, (Object)end);
    }

    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vector3d start, Vector3d end, Collection<VoxelShape> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult hit = null;
        int i = -1;
        for (VoxelShape shape : boxes) {
            BlockRayTraceResult result;
            if (shape != null && (result = shape.func_212433_a(start, end, pos)) != null) {
                result.subHit = i;
                result.hitInfo = null;
                AdvancedRayTraceResult advancedResult = new AdvancedRayTraceResult((RayTraceResult)result, shape);
                double d = advancedResult.squareDistanceTo(start);
                if (d < minDistance) {
                    minDistance = d;
                    hit = advancedResult;
                }
            }
            ++i;
        }
        return hit;
    }

    public static class AdvancedRayTraceResult {
        public final VoxelShape bounds;
        public final RayTraceResult hit;

        public AdvancedRayTraceResult(RayTraceResult mop, VoxelShape shape) {
            this.hit = mop;
            this.bounds = shape;
        }

        public boolean valid() {
            return this.hit != null && this.bounds != null;
        }

        public double squareDistanceTo(Vector3d vec) {
            return this.hit.func_216347_e().func_72436_e(vec);
        }
    }
}

