/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.inventory.IInventorySlot;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.items.ItemHandlerHelper;

public final class StackUtils {
    private StackUtils() {
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    public static List<ItemStack> getMergeRejects(@Nonnull List<IInventorySlot> orig, @Nonnull List<IInventorySlot> toAdd) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < toAdd.size(); ++i) {
            ItemStack reject;
            IInventorySlot toAddSlot = toAdd.get(i);
            if (toAddSlot.isEmpty() || (reject = StackUtils.getMergeReject(orig.get(i).getStack(), toAddSlot.getStack())).func_190926_b()) continue;
            ret.add(reject);
        }
        return ret;
    }

    public static void merge(@Nonnull List<IInventorySlot> orig, @Nonnull List<IInventorySlot> toAdd) {
        for (int i = 0; i < toAdd.size(); ++i) {
            IInventorySlot toAddSlot = toAdd.get(i);
            if (toAddSlot.isEmpty()) continue;
            IInventorySlot origSlot = orig.get(i);
            origSlot.setStack(StackUtils.merge(origSlot.getStack(), toAddSlot.getStack()));
        }
    }

    private static ItemStack merge(ItemStack orig, ItemStack toAdd) {
        if (orig.func_190926_b()) {
            return toAdd;
        }
        if (toAdd.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)orig, (ItemStack)toAdd)) {
            return orig;
        }
        return StackUtils.size(orig, Math.min(orig.func_77976_d(), orig.func_190916_E() + toAdd.func_190916_E()));
    }

    private static ItemStack getMergeReject(ItemStack orig, ItemStack toAdd) {
        if (orig.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (toAdd.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)orig, (ItemStack)toAdd)) {
            return orig;
        }
        int newSize = orig.func_190916_E() + toAdd.func_190916_E();
        if (newSize > orig.func_77976_d()) {
            return StackUtils.size(orig, newSize - orig.func_77976_d());
        }
        return StackUtils.size(orig, newSize);
    }

    @Nullable
    public static BlockState getStateForPlacement(ItemStack stack, BlockPos pos, PlayerEntity player) {
        return Block.func_149634_a((Item)stack.func_77973_b()).func_196258_a(new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, new BlockRayTraceResult(Vector3d.field_186680_a, Direction.UP, pos, false))));
    }
}

