/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemRepository;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public abstract class StandardDrawerGroup
extends TileDataShim
implements IDrawerGroup {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    @CapabilityInject(value=IItemRepository.class)
    public static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = null;
    private DrawerData[] slots;
    private int[] order;
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new DrawerItemHandler(this));
    private final LazyOptional<IItemRepository> itemRepository = LazyOptional.of(() -> new DrawerItemRepository(this));

    public StandardDrawerGroup(int slotCount) {
        this.slots = new DrawerData[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = this.createDrawer(i);
        }
        this.order = new int[slotCount];
        this.syncSlots();
    }

    public void setCapabilityProvider(ICapabilityProvider capProvider) {
        for (DrawerData slot : this.slots) {
            slot.setCapabilityProvider(capProvider);
        }
    }

    @Override
    public int getDrawerCount() {
        return this.slots.length;
    }

    @Override
    @Nonnull
    public IDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.slots.length) {
            return Drawers.DISABLED;
        }
        return this.slots[slot];
    }

    @Override
    @Nonnull
    public int[] getAccessibleDrawerSlots() {
        return this.order;
    }

    @Override
    public void read(CompoundNBT tag) {
        if (!tag.func_74764_b("Drawers")) {
            return;
        }
        ListNBT itemList = tag.func_150295_c("Drawers", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            if (i >= this.slots.length) continue;
            this.slots[i].deserializeNBT(itemList.func_150305_b(i));
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        if (this.slots == null) {
            return tag;
        }
        ListNBT itemList = new ListNBT();
        for (DrawerData slot : this.slots) {
            itemList.add((Object)slot.serializeNBT());
        }
        tag.func_218657_a("Drawers", (INBT)itemList);
        return tag;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (capability == ITEM_REPOSITORY_CAPABILITY) {
            return this.itemRepository.cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    protected abstract DrawerData createDrawer(int var1);

    public void syncAttributes() {
        for (DrawerData drawer : this.slots) {
            drawer.syncAttributes();
        }
    }

    public void syncSlots() {
        IDrawer drawer;
        int i;
        int index = 0;
        for (i = 0; i < this.slots.length; ++i) {
            drawer = this.getDrawer(i);
            if (drawer.isEmpty()) continue;
            this.order[index++] = i;
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (!drawer.isEnabled() || !drawer.isEmpty()) continue;
                this.order[index++] = i;
            }
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (drawer.isEnabled()) continue;
                this.order[index++] = i;
            }
        }
    }

    public static class DrawerData
    implements IDrawer,
    INBTSerializable<CompoundNBT> {
        @CapabilityInject(value=IDrawerAttributes.class)
        static Capability<IDrawerAttributes> ATTR_CAPABILITY = null;
        IDrawerAttributes attrs;
        StandardDrawerGroup group;
        @Nonnull
        private ItemStack protoStack;
        private int count;
        private ItemStackMatcher matcher;

        public DrawerData(StandardDrawerGroup group) {
            this.group = group;
            this.attrs = EmptyDrawerAttributes.EMPTY;
            this.protoStack = ItemStack.field_190927_a;
            this.matcher = ItemStackMatcher.EMPTY;
        }

        public void setCapabilityProvider(ICapabilityProvider capProvider) {
            this.attrs = (IDrawerAttributes)capProvider.getCapability(ATTR_CAPABILITY, null).orElse((Object)EmptyDrawerAttributes.EMPTY);
        }

        @Override
        @Nonnull
        public ItemStack getStoredItemPrototype() {
            return this.protoStack;
        }

        @Override
        @Nonnull
        public IDrawer setStoredItem(@Nonnull ItemStack itemPrototype) {
            return this.setStoredItem(itemPrototype, true);
        }

        protected IDrawer setStoredItem(@Nonnull ItemStack itemPrototype, boolean notify) {
            if (ItemStackHelper.isStackEncoded(itemPrototype)) {
                itemPrototype = ItemStackHelper.decodeItemStackPrototype(itemPrototype);
            }
            if (this.matcher.matches(itemPrototype)) {
                return this;
            }
            if ((itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype)).func_190926_b()) {
                this.reset(notify);
                return this;
            }
            this.protoStack = itemPrototype;
            this.protoStack.func_190920_e(1);
            this.count = 0;
            this.matcher = new ItemStackMatcher(this.protoStack);
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
            return this;
        }

        protected IDrawer setStoredItemRaw(@Nonnull ItemStack itemPrototype) {
            this.protoStack = itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype);
            this.protoStack.func_190920_e(1);
            this.count = 0;
            this.matcher = new ItemStackMatcher(this.protoStack);
            return this;
        }

        @Override
        public int getStoredItemCount() {
            if (this.protoStack.func_190926_b()) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.count;
        }

        @Override
        public void setStoredItemCount(int amount) {
            this.setStoredItemCount(amount, true);
        }

        protected void setStoredItemCount(int amount, boolean notify) {
            if (this.protoStack.func_190926_b() || this.count == amount) {
                return;
            }
            if (this.attrs.isUnlimitedVending()) {
                return;
            }
            this.count = Math.min(amount, this.getMaxCapacity());
            this.count = Math.max(this.count, 0);
            if (this.count == 0 && !this.attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset(notify);
            } else if (notify) {
                this.onAmountChanged();
            }
        }

        protected void setStoredItemCountRaw(int amount) {
            this.count = amount;
        }

        @Override
        public int adjustStoredItemCount(int amount) {
            return this.adjustStoredItemCount(amount, true);
        }

        protected int adjustStoredItemCount(int amount, boolean notify) {
            if (this.protoStack.func_190926_b() || amount == 0) {
                return Math.abs(amount);
            }
            if (amount > 0) {
                if (this.attrs.isUnlimitedVending()) {
                    return 0;
                }
                int originalCount = this.count;
                this.count = Math.min(this.count + amount, this.getMaxCapacity());
                if (this.count != originalCount && notify) {
                    this.onAmountChanged();
                }
                if (this.attrs.isVoid()) {
                    return 0;
                }
                return amount - (this.count - originalCount);
            }
            if (this.attrs.isUnlimitedVending()) {
                return 0;
            }
            int originalCount = this.count;
            this.setStoredItemCount(originalCount + amount, notify);
            return -amount - (originalCount - this.count);
        }

        @Override
        public int getMaxCapacity(@Nonnull ItemStack itemPrototype) {
            if (this.attrs.isUnlimitedStorage() || this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            if (itemPrototype.func_190926_b()) {
                return 64 * this.getStackCapacity();
            }
            return itemPrototype.func_77973_b().getItemStackLimit(itemPrototype) * this.getStackCapacity();
        }

        @Override
        public int getAcceptingMaxCapacity(@Nonnull ItemStack itemPrototype) {
            if (this.attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(itemPrototype);
        }

        @Override
        public int getRemainingCapacity() {
            if (this.protoStack.func_190926_b()) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public int getAcceptingRemainingCapacity() {
            if (this.protoStack.func_190926_b()) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending() || this.attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public boolean canItemBeStored(@Nonnull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            if (this.protoStack.func_190926_b() && !this.attrs.isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return true;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean canItemBeExtracted(@Nonnull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            if (this.protoStack.func_190926_b()) {
                return false;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean isEmpty() {
            return this.protoStack.func_190926_b();
        }

        protected void reset(boolean notify) {
            this.protoStack = ItemStack.field_190927_a;
            this.count = 0;
            this.matcher = ItemStackMatcher.EMPTY;
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            if (this.protoStack.func_190926_b()) {
                return tag;
            }
            CompoundNBT item = new CompoundNBT();
            this.protoStack.func_77955_b(item);
            tag.func_218657_a("Item", (INBT)item);
            tag.func_74768_a("Count", this.count);
            return tag;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            ItemStack tagItem = ItemStack.field_190927_a;
            int tagCount = 0;
            if (nbt.func_74764_b("Item")) {
                tagItem = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item"));
            }
            if (nbt.func_74764_b("Count")) {
                tagCount = nbt.func_74762_e("Count");
            }
            this.setStoredItemRaw(tagItem);
            this.setStoredItemCountRaw(tagCount);
        }

        public void syncAttributes() {
            if (!this.protoStack.func_190926_b()) {
                this.matcher = new ItemStackMatcher(this.protoStack);
            }
        }

        protected int getStackCapacity() {
            return 0;
        }

        protected void onItemChanged() {
        }

        protected void onAmountChanged() {
        }
    }
}

