/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public final class CommonConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final Upgrades UPGRADES = new Upgrades(BUILDER);
    public static final Integration INTEGRATION = new Integration(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class Upgrades {
        public final ForgeConfigSpec.ConfigValue<Integer> level1Mult;
        public final ForgeConfigSpec.ConfigValue<Integer> level2Mult;
        public final ForgeConfigSpec.ConfigValue<Integer> level3Mult;
        public final ForgeConfigSpec.ConfigValue<Integer> level4Mult;
        public final ForgeConfigSpec.ConfigValue<Integer> level5Mult;

        public Upgrades(ForgeConfigSpec.Builder builder) {
            builder.push("StorageUpgrades");
            builder.comment(new String[]{"Storage upgrades multiply storage capacity by the given amount.", "When multiple storage upgrades are used together, their multipliers are added before being applied."});
            this.level1Mult = builder.define("level1Mult", (Object)2);
            this.level2Mult = builder.define("level2Mult", (Object)4);
            this.level3Mult = builder.define("level3Mult", (Object)8);
            this.level4Mult = builder.define("level4Mult", (Object)16);
            this.level5Mult = builder.define("level5Mult", (Object)32);
            builder.pop();
        }

        public int getLevelMult(int level) {
            if (!CommonConfig.isLoaded()) {
                return 1;
            }
            switch (level) {
                case 1: {
                    return (Integer)this.level1Mult.get();
                }
                case 2: {
                    return (Integer)this.level2Mult.get();
                }
                case 3: {
                    return (Integer)this.level3Mult.get();
                }
                case 4: {
                    return (Integer)this.level4Mult.get();
                }
                case 5: {
                    return (Integer)this.level5Mult.get();
                }
            }
            return 1;
        }
    }

    public static class Integration {
        public final ForgeConfigSpec.ConfigValue<Boolean> wailaStackRemainder;

        public Integration(ForgeConfigSpec.Builder builder) {
            builder.push("Integration");
            this.wailaStackRemainder = builder.define("wailaStackRemainder", true);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Integer> baseStackStorage;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableUI;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableSidedInput;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableSidedOutput;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableItemConversion;
        public final ForgeConfigSpec.ConfigValue<Boolean> debugTrace;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableExtraCompactingRules;
        public final ForgeConfigSpec.ConfigValue<Integer> controllerRange;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> compRules;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            ArrayList<String> test = new ArrayList<String>();
            test.add("minecraft:clay, minecraft:clay_ball, 4");
            this.baseStackStorage = builder.comment(new String[]{"The number of item stacks held in a basic unit of storage.", "1x1 drawers hold 8 units, 1x2 drawers hold 4 units, 2x2 drawers hold 2 units.", "Half-depth drawers hold half those amounts."}).define("baseStackStorage", (Object)4);
            this.controllerRange = builder.defineInRange("controllerRange", 12, 1, 50);
            this.enableUI = builder.define("enableUI", true);
            this.enableSidedInput = builder.define("enableSidedInput", true);
            this.enableSidedOutput = builder.define("enableSidedOutput", true);
            this.enableItemConversion = builder.define("enableItemConversion", true);
            this.enableExtraCompactingRules = builder.define("enableExtraCompactingRules", true);
            this.debugTrace = builder.define("debugTrace", false);
            this.compRules = builder.comment(new String[]{"List of rules in format \"domain:item1, domain:item2, n\".", "Causes a compacting drawer convert n of item1 into 1 of item2."}).defineList("compactingRules", test, obj -> CompTierRegistry.validateRuleSyntax((String)obj));
            builder.pop();
        }

        public int getBaseStackStorage() {
            if (!CommonConfig.isLoaded()) {
                return 1;
            }
            return (Integer)this.baseStackStorage.get();
        }
    }
}

