/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.soil;

import java.util.Optional;
import java.util.Set;
import net.darkhax.bookshelf.block.DisplayableBlockState;
import net.darkhax.bookshelf.crafting.RecipeDataBase;
import net.darkhax.botanypots.BotanyPots;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;

public class SoilInfo
extends RecipeDataBase {
    private Ingredient ingredient;
    private DisplayableBlockState renderState;
    private float growthModifier;
    private Set<String> categories;
    private Optional<Integer> lightLevel;

    public SoilInfo(ResourceLocation id, Ingredient ingredient, BlockState renderState, float growthModifier, Set<String> categories, Optional<Integer> lightLevel) {
        this(id, ingredient, new DisplayableBlockState(renderState), growthModifier, categories, lightLevel);
    }

    public SoilInfo(ResourceLocation id, Ingredient ingredient, DisplayableBlockState renderState, float growthModifier, Set<String> categories, Optional<Integer> lightLevel) {
        super(id);
        this.ingredient = ingredient;
        this.renderState = renderState;
        this.growthModifier = growthModifier;
        this.categories = categories;
        this.lightLevel = lightLevel;
    }

    public float getGrowthModifier() {
        return this.growthModifier;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public DisplayableBlockState getRenderState() {
        return this.renderState;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    @Deprecated
    public ItemStack getFirstSoil() {
        ItemStack[] matchingStacks = this.ingredient.func_193365_a();
        return matchingStacks.length > 0 ? matchingStacks[0] : ItemStack.field_190927_a;
    }

    public void setIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public void setRenderState(BlockState renderState) {
        this.setRenderState(new DisplayableBlockState(renderState));
    }

    public void setRenderState(DisplayableBlockState renderState) {
        this.renderState = renderState;
    }

    public void setGrowthModifier(float modifier) {
        this.growthModifier = modifier;
    }

    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    public ITextComponent getName() {
        return new TranslationTextComponent(this.getRenderState().getState().func_177230_c().func_149739_a());
    }

    public void setLightLevel(int lightLevel) {
        this.lightLevel = Optional.of(lightLevel);
    }

    public Optional<Integer> getLightLevel() {
        return this.lightLevel;
    }

    public int getLightLevel(IBlockReader world, BlockPos pos) {
        return this.getLightLevel().orElseGet(() -> this.renderState.getState().getLightValue(world, pos));
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return BotanyPots.instance.getContent().recipeSerializerSoil;
    }

    public IRecipeType<?> func_222127_g() {
        return BotanyPots.instance.getContent().recipeTypeSoil;
    }
}

