/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.soil;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.darkhax.bookshelf.block.DisplayableBlockState;
import net.darkhax.bookshelf.serialization.Serializers;
import net.darkhax.bookshelf.util.PacketUtils;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SoilSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<SoilInfo> {
    public static final SoilSerializer INSTANCE = new SoilSerializer();

    public SoilInfo read(ResourceLocation id, JsonObject json) {
        int lightVal;
        Ingredient input = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("input"));
        DisplayableBlockState renderState = (DisplayableBlockState)Serializers.DISPLAY_STATE.read(json.get("display"));
        float growthModifier = JSONUtils.func_151217_k((JsonObject)json, (String)"growthModifier");
        Set categories = Serializers.STRING.readSet(json, "categories");
        Optional lightLevel = Serializers.INT.readOptional(json, "lightLevel");
        if (growthModifier <= -1.0f) {
            throw new IllegalArgumentException("Soil " + id + " has an invalid growth modifier. It must be greater than -1.");
        }
        if (lightLevel.isPresent() && ((lightVal = ((Integer)lightLevel.get()).intValue()) > 15 || lightVal < 0)) {
            throw new IllegalArgumentException("Light level should be between 0 and 15. Value was " + lightLevel.get());
        }
        return new SoilInfo(id, input, renderState, growthModifier, (Set<String>)categories, (Optional<Integer>)lightLevel);
    }

    public SoilInfo read(ResourceLocation id, PacketBuffer buf) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buf);
        DisplayableBlockState renderState = (DisplayableBlockState)Serializers.DISPLAY_STATE.read(buf);
        float growthModifier = buf.readFloat();
        HashSet<String> categories = new HashSet<String>();
        PacketUtils.deserializeStringCollection((PacketBuffer)buf, categories);
        Optional lightLevel = Serializers.INT.readOptional(buf);
        return new SoilInfo(id, ingredient, renderState, growthModifier, categories, (Optional<Integer>)lightLevel);
    }

    public void write(PacketBuffer buffer, SoilInfo info) {
        info.getIngredient().func_199564_a(buffer);
        Serializers.DISPLAY_STATE.write(buffer, (Object)info.getRenderState());
        buffer.writeFloat(info.getGrowthModifier());
        PacketUtils.serializeStringCollection((PacketBuffer)buffer, info.getCategories());
        Serializers.INT.writeOptional(buffer, info.getLightLevel());
    }
}

