/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.value.CachedPrimitiveValue;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.util.ToolsUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class ItemMekanismHoe
extends HoeItem
implements IHasRepairType,
IAttributeRefresher {
    private final MaterialCreator material;
    private final AttributeCache attributeCache;

    public ItemMekanismHoe(MaterialCreator material, Item.Properties properties) {
        super((IItemTier)material, (int)material.getHoeDamage(), material.getHoeAtkSpeed(), properties);
        this.material = material;
        this.attributeCache = new AttributeCache((IAttributeRefresher)this, new CachedPrimitiveValue[]{material.attackDamage, material.hoeDamage, material.hoeAtkSpeed});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        ToolsUtils.addDurability(tooltip, stack);
    }

    public float func_234675_d_() {
        return this.material.getHoeDamage() + this.func_200891_e().func_200929_c();
    }

    @Override
    @Nonnull
    public Ingredient getRepairMaterial() {
        return this.func_200891_e().func_200924_f();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.func_200891_e().func_200926_a();
    }

    public boolean func_77645_m() {
        return this.func_200891_e().func_200926_a() > 0;
    }

    public int getHarvestLevel(@Nonnull ItemStack stack, @Nonnull ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return tool == ToolType.HOE ? this.func_200891_e().func_200925_d() : super.getHarvestLevel(stack, tool, player, blockState);
    }

    public float func_150893_a(@Nonnull ItemStack stack, BlockState state) {
        if (this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) || this.field_150914_c.contains(state.func_177230_c())) {
            return this.func_200891_e().func_200928_b();
        }
        return 1.0f;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, @Nonnull ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeCache.getAttributes() : ImmutableMultimap.of();
    }

    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.func_234675_d_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.material.getHoeAtkSpeed(), AttributeModifier.Operation.ADDITION));
    }
}

