/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.init;

import com.blakebr0.cucumber.block.BaseBlock;
import com.blakebr0.cucumber.block.BaseOreBlock;
import com.blakebr0.cucumber.item.BaseBlockItem;
import com.blakebr0.mysticalagradditions.MysticalAgradditions;
import com.blakebr0.mysticalagradditions.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagradditions.init.ModFluids;
import com.blakebr0.mysticalagradditions.init.ModItems;
import com.blakebr0.mysticalagradditions.item.EssenceCoalBlockItem;
import com.blakebr0.mysticalagradditions.lib.ModCorePlugin;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModBlocks {
    public static final Map<RegistryObject<Block>, Supplier<Block>> ENTRIES = new LinkedHashMap<RegistryObject<Block>, Supplier<Block>>();
    public static final RegistryObject<Block> INSANIUM_BLOCK = ModBlocks.register("insanium_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 4.0f, 6.0f));
    public static final RegistryObject<Block> INSANIUM_INGOT_BLOCK = ModBlocks.register("insanium_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f));
    public static final RegistryObject<Block> INSANIUM_GEMSTONE_BLOCK = ModBlocks.register("insanium_gemstone_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f));
    public static final RegistryObject<Block> INSANIUM_FARMLAND = ModBlocks.register("insanium_farmland", () -> new InfusedFarmlandBlock(ModCorePlugin.CROP_TIER_6));
    public static final RegistryObject<Block> INFERIUM_COAL_BLOCK = ModBlocks.register("inferium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 21600, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> PRUDENTIUM_COAL_BLOCK = ModBlocks.register("prudentium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 43200, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> TERTIUM_COAL_BLOCK = ModBlocks.register("tertium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 86400, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> IMPERIUM_COAL_BLOCK = ModBlocks.register("imperium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 172800, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> SUPREMIUM_COAL_BLOCK = ModBlocks.register("supremium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 345600, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> INSANIUM_COAL_BLOCK = ModBlocks.register("insanium_coal_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 691200, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Block> NETHER_PROSPERITY_ORE = ModBlocks.register("nether_prosperity_ore", () -> new BaseOreBlock(Material.field_151576_e, SoundType.field_185851_d, 3.0f, 3.0f, 2, 5));
    public static final RegistryObject<Block> NETHER_INFERIUM_ORE = ModBlocks.register("nether_inferium_ore", () -> new BaseOreBlock(Material.field_151576_e, SoundType.field_185851_d, 3.0f, 3.0f, 2, 5));
    public static final RegistryObject<Block> END_PROSPERITY_ORE = ModBlocks.register("end_prosperity_ore", () -> new BaseOreBlock(Material.field_151576_e, SoundType.field_185851_d, 3.0f, 3.0f, 2, 5));
    public static final RegistryObject<Block> END_INFERIUM_ORE = ModBlocks.register("end_inferium_ore", () -> new BaseOreBlock(Material.field_151576_e, SoundType.field_185851_d, 3.0f, 3.0f, 2, 5));
    public static final RegistryObject<Block> NETHER_STAR_CRUX = ModBlocks.register("nether_star_crux", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 10.0f));
    public static final RegistryObject<Block> DRAGON_EGG_CRUX = ModBlocks.register("dragon_egg_crux", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 10.0f));
    public static final RegistryObject<Block> AWAKENED_DRACONIUM_CRUX = ModBlocks.register("awakened_draconium_crux", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 10.0f));
    public static final RegistryObject<Block> NITRO_CRYSTAL_CRUX = ModBlocks.register("nitro_crystal_crux", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 10.0f));
    public static final RegistryObject<Block> MOLTEN_INFERIUM = ModBlocks.registerNoItem("molten_inferium", () -> new FlowingFluidBlock(ModFluids.MOLTEN_INFERIUM, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150353_l)));
    public static final RegistryObject<Block> MOLTEN_PRUDENTIUM = ModBlocks.registerNoItem("molten_prudentium", () -> new FlowingFluidBlock(ModFluids.MOLTEN_PRUDENTIUM, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150353_l)));
    public static final RegistryObject<Block> MOLTEN_TERTIUM = ModBlocks.registerNoItem("molten_tertium", () -> new FlowingFluidBlock(ModFluids.MOLTEN_TERTIUM, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150353_l)));
    public static final RegistryObject<Block> MOLTEN_IMPERIUM = ModBlocks.registerNoItem("molten_imperium", () -> new FlowingFluidBlock(ModFluids.MOLTEN_IMPERIUM, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150353_l)));
    public static final RegistryObject<Block> MOLTEN_SUPREMIUM = ModBlocks.registerNoItem("molten_supremium", () -> new FlowingFluidBlock(ModFluids.MOLTEN_SUPREMIUM, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150353_l)));
    public static final RegistryObject<Block> MOLTEN_SOULIUM = ModBlocks.registerNoItem("molten_soulium", () -> new FlowingFluidBlock(ModFluids.MOLTEN_SOULIUM, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150353_l)));

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ENTRIES.forEach((reg, block) -> {
            registry.register((IForgeRegistryEntry)block.get());
            reg.updateReference(registry);
        });
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block) {
        return ModBlocks.register(name, block, b -> () -> new BaseBlockItem((Block)b.get(), p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block, Function<RegistryObject<Block>, Supplier<? extends BlockItem>> item) {
        ResourceLocation loc = new ResourceLocation("mysticalagradditions", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.BLOCKS);
        ENTRIES.put((RegistryObject<Block>)reg, () -> (Block)((Block)block.get()).setRegistryName(loc));
        ModItems.BLOCK_ENTRIES.add(() -> (Item)((BlockItem)((Supplier)item.apply(reg)).get()).setRegistryName(loc));
        return reg;
    }

    public static RegistryObject<Block> registerNoItem(String name, Supplier<Block> block) {
        ResourceLocation loc = new ResourceLocation("mysticalagradditions", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.BLOCKS);
        ENTRIES.put((RegistryObject<Block>)reg, () -> (Block)((Block)block.get()).setRegistryName(loc));
        return reg;
    }
}

