/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.container;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackHandlerSeedBag
extends ItemStackHandler {
    public static final int MIN_BAG_SLOTS = 1;
    public static final int MAX_BAG_SLOTS = 16;
    public final int tier;
    private boolean isDirty = true;

    public ItemStackHandlerSeedBag(int tier, int numberOfSlots) {
        super(MathHelper.func_76125_a((int)numberOfSlots, (int)1, (int)16));
        this.tier = tier;
        if (numberOfSlots < 1 || numberOfSlots > 16) {
            throw new IllegalArgumentException("Invalid number of seed slots: " + numberOfSlots);
        }
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (slot < 0 || slot >= 16) {
            throw new IllegalArgumentException("Invalid slot number: " + slot);
        }
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return this.getSeedTier(this.tier, item);
    }

    public int getNumberOfEmptySlots() {
        int NUMBER_OF_SLOTS = this.getSlots();
        int emptySlots = 0;
        for (int i = 0; i < NUMBER_OF_SLOTS; ++i) {
            if (!this.getStackInSlot(i).func_190926_b()) continue;
            ++emptySlots;
        }
        return emptySlots;
    }

    public boolean isDirty() {
        boolean currentState = this.isDirty;
        this.isDirty = false;
        return currentState;
    }

    protected void onContentsChanged(int slot) {
        this.isDirty = true;
    }

    private boolean getSeedTier(int tier, Item item) {
        for (ICrop crop : MysticalAgricultureAPI.getCropRegistry().getCrops()) {
            if (!crop.getSeeds().equals(item)) continue;
            return crop.getTier().getValue() == tier;
        }
        return false;
    }
}

