/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.init;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.github.elrol.industrialagriculture.IndustrialAgriculture;
import com.github.elrol.industrialagriculture.init.ColorInit;
import com.github.elrol.industrialagriculture.init.CruxInit;
import com.github.elrol.industrialagriculture.init.SoulInit;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CropInit {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Crop> cropMap = new HashMap<String, Crop>();
    private static final CropTextures animalTextures = new CropTextures(CropTextures.FLOWER_FACE_BLANK, CropTextures.ESSENCE_ROCK_BLANK, CropTextures.SEED_BLANK);
    private static final CropTextures ingotTextures = new CropTextures(CropTextures.FLOWER_INGOT_BLANK, CropTextures.ESSENCE_INGOT_BLANK, CropTextures.SEED_BLANK);

    public static void init(ICropRegistry registry) {
        CruxInit.addCruxBlocks(IndustrialAgriculture.config.getCruxMap());
        LOGGER.info("Updating Crops");
        registry.getCrops().forEach(CropInit::updateCrop);
        CropInit.initEntityCrop("bat");
        CropInit.initEntityCrop("cat");
        CropInit.initEntityCrop("fox");
        CropInit.initEntityCrop("panda");
        CropInit.initEntityCrop("parrot");
        CropInit.initEntityCrop("wolf");
        CropInit.initEntityCrop("dolphin");
        CropInit.initEntityCrop("horse");
        CropInit.initEntityCrop("drowned");
        CropInit.initEntityCrop("guardian");
        CropInit.initEntityCrop("husk");
        CropInit.initEntityCrop("llama");
        CropInit.initEntityCrop("polar_bear");
        CropInit.initEntityCrop("silverfish");
        CropInit.initEntityCrop("stray");
        CropInit.initEntityCrop("vex");
        CropInit.initEntityCrop("witch");
        CropInit.initEntityCrop("zombified_piglin");
        CropInit.initEntityCrop("endermite");
        CropInit.initEntityCrop("magma_cube");
        CropInit.initEntityCrop("mooshroom");
        CropInit.initEntityCrop("phantom");
        CropInit.initEntityCrop("piglin");
        CropInit.initEntityCrop("piglin_brute");
        CropInit.initEntityCrop("pillager");
        CropInit.initEntityCrop("ravager");
        CropInit.initEntityCrop("shulker");
        CropInit.initEntityCrop("villager");
        CropInit.initEntityCrop("vindicator");
        CropInit.initEntityCrop("evoker");
        CropInit.register(registry);
    }

    private static void register(ICropRegistry registry) {
        for (Map.Entry<String, Crop> entry : cropMap.entrySet()) {
            registry.register((ICrop)entry.getValue());
            LOGGER.info(entry.getKey() + " = " + entry.getValue().toString() + ". Has been registered");
        }
    }

    private static void initEntityCrop(String name) {
        CropInit.addEntityCrop(name, IndustrialAgriculture.config.getTier(name));
    }

    public static Crop getCrop(String name) {
        return cropMap.get(name);
    }

    public static <T extends Block> void addItemResourceCrop(String name, CropTier tier, String item, CropTextures textures) {
        if (cropMap.containsKey(name)) {
            LOGGER.info("Entity Crop[" + name + "] already exists");
            return;
        }
        int color = ColorInit.getColor(name);
        Crop crop = color == 0 ? new Crop(new ResourceLocation("industrialagriculture", name), tier, CropType.RESOURCE, textures, LazyIngredient.item((String)item)) : new Crop(new ResourceLocation("industrialagriculture", name), tier, CropType.RESOURCE, textures, color, LazyIngredient.item((String)item));
        RegistryObject crux = CruxInit.getCrux(name);
        if (crux != null) {
            crop.setCrux(crux);
        }
        cropMap.put(name, crop);
    }

    public static <T extends Block> void addIngotTagResourceCrop(String name, CropTier tier, String tag) {
        CropInit.addTagResourceCrop(name, tier, tag, ingotTextures);
    }

    public static <T extends Block> void addTagResourceCrop(String name, CropTier tier, String tag, CropTextures textures) {
        if (cropMap.containsKey(name)) {
            LOGGER.info("Entity Crop[" + name + "] already exists.");
        } else {
            int color = ColorInit.getColor(name);
            Crop crop = color == 0 ? new Crop(new ResourceLocation("industrialagriculture", name), tier, CropType.RESOURCE, textures, LazyIngredient.tag((String)tag)) : new Crop(new ResourceLocation("industrialagriculture", name), tier, CropType.RESOURCE, textures, color, LazyIngredient.tag((String)tag));
            RegistryObject crux = CruxInit.getCrux(name);
            if (crux != null) {
                crop.setCrux(crux);
            }
            cropMap.put(name, crop);
        }
    }

    public static <T extends Block> void addResourceCrop(String name, CropTier tier, CropTextures textures) {
        if (cropMap.containsKey(name)) {
            LOGGER.info("Entity Crop[" + name + "] already exists.");
        } else {
            int color = ColorInit.getColor(name);
            Crop crop = color == 0 ? new Crop(new ResourceLocation("industrialagriculture", name), tier, CropType.RESOURCE, textures, LazyIngredient.EMPTY) : new Crop(new ResourceLocation("industrialagriculture", name), tier, CropType.RESOURCE, textures, color, LazyIngredient.EMPTY);
            RegistryObject crux = CruxInit.getCrux(name);
            if (crux != null) {
                crop.setCrux(crux);
            }
            cropMap.put(name, crop);
        }
    }

    public static <T extends Block> void addEntityCrop(String name, CropTier tier) {
        if (cropMap.containsKey(name)) {
            LOGGER.info("Entity Crop[" + name + "] already exists.");
        } else {
            int color = ColorInit.getColor(name);
            Crop crop = color == 0 ? new Crop(new ResourceLocation("industrialagriculture", name), tier, CropType.MOB, animalTextures, LazyIngredient.item((String)"mysticalagriculture:soul_jar", (CompoundNBT)MobSoulUtils.makeTag((IMobSoulType)SoulInit.getSoul(name)))) : new Crop(new ResourceLocation("industrialagriculture", name), tier, CropType.MOB, animalTextures, color, LazyIngredient.item((String)"mysticalagriculture:soul_jar", (CompoundNBT)MobSoulUtils.makeTag((IMobSoulType)SoulInit.getSoul(name))));
            RegistryObject crux = CruxInit.getCrux(name);
            if (crux != null) {
                crop.setCrux(crux);
            }
            cropMap.put(name, crop);
        }
    }

    public static <T extends Block> void updateCrop(ICrop crop) {
        String name = crop.getName();
        String block = CruxInit.getOrCreateCruxBlock(name);
        if (block.isEmpty()) {
            return;
        }
        ResourceLocation loc = new ResourceLocation(block);
        RegistryObject crux = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.BLOCKS);
        crop.setCrux((Supplier)crux);
    }
}

