/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.init;

import com.github.elrol.industrialagriculture.IndustrialAgriculture;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CruxInit {
    private static final Logger logger = Logger.getLogger(CruxInit.class.getName());
    public static final Map<String, String> cruxMap = new HashMap<String, String>();

    public static void addCruxBlocks(Map<String, String> cruxes) {
        cruxes.forEach((name, crux) -> {
            if (cruxMap.containsKey(name)) {
                if (crux.isEmpty()) {
                    return;
                }
                if (!cruxMap.get(name).isEmpty()) {
                    logger.info("Crux [" + name + "] was already set with: " + cruxMap.get(name));
                    return;
                }
                cruxMap.put((String)name, (String)crux);
                logger.info("Crux [" + name + "] was replaced with: " + crux);
                return;
            }
            cruxMap.put((String)name, (String)crux);
            logger.info("Crux [" + name + "," + crux + "] was registered");
        });
    }

    public static String getOrCreateCruxBlock(String name) {
        if (!cruxMap.containsKey(name)) {
            IndustrialAgriculture.config.addCrux(name, "");
            return "";
        }
        return cruxMap.get(name);
    }

    public static String getCruxBlock(String name) {
        return cruxMap.getOrDefault(name, "");
    }

    public static <T extends Block> RegistryObject<T> getCrux(String name) {
        if (name.isEmpty()) {
            return null;
        }
        String block = CruxInit.getCruxBlock(name);
        if (block.isEmpty()) {
            return null;
        }
        return RegistryObject.of((ResourceLocation)new ResourceLocation(block), (IForgeRegistry)ForgeRegistries.BLOCKS);
    }
}

