/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.init;

import com.blakebr0.mysticalagriculture.api.registry.IMobSoulTypeRegistry;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.github.elrol.industrialagriculture.IndustrialAgriculture;
import com.github.elrol.industrialagriculture.init.ColorInit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.util.ResourceLocation;

public class SoulInit {
    private static final Logger logger = Logger.getLogger(SoulInit.class.getName());
    private static final Map<String, Set<ResourceLocation>> entityMap = new HashMap<String, Set<ResourceLocation>>();
    private static final Map<String, MobSoulType> soulMap = new HashMap<String, MobSoulType>();

    public static void preinit() {
        SoulInit.addEntity("bat", new ResourceLocation("minecraft:bat"));
        SoulInit.addEntity("cat", new ResourceLocation("minecraft:cat"));
        SoulInit.addEntity("dolphin", new ResourceLocation("minecraft:dolphin"));
        SoulInit.addEntity("horse", new ResourceLocation("minecraft:horse"));
        SoulInit.addEntity("drowned", new ResourceLocation("minecraft:drowned"));
        SoulInit.addEntity("guardian", new ResourceLocation("minecraft:guardian"));
        SoulInit.addEntity("endermite", new ResourceLocation("minecraft:endermite"));
        SoulInit.addEntity("evoker", new ResourceLocation("minecraft:evoker"));
        SoulInit.addEntity("fox", new ResourceLocation("minecraft:fox"));
        SoulInit.addEntity("husk", new ResourceLocation("minecraft:husk"));
        SoulInit.addEntity("llama", new ResourceLocation("minecraft:llama"));
        SoulInit.addEntity("magma_cube", new ResourceLocation("minecraft:magma_cube"));
        SoulInit.addEntity("mooshroom", new ResourceLocation("minecraft:mooshroom"));
        SoulInit.addEntity("panda", new ResourceLocation("minecraft:panda"));
        SoulInit.addEntity("parrot", new ResourceLocation("minecraft:parrot"));
        SoulInit.addEntity("phantom", new ResourceLocation("minecraft:phantom"));
        SoulInit.addEntity("piglin", new ResourceLocation("minecraft:piglin"));
        SoulInit.addEntity("piglin_brute", new ResourceLocation("minecraft:piglin_brute"));
        SoulInit.addEntity("pillager", new ResourceLocation("minecraft:pillager"));
        SoulInit.addEntity("polar_bear", new ResourceLocation("minecraft:polar_bear"));
        SoulInit.addEntity("ravager", new ResourceLocation("minecraft:ravager"));
        SoulInit.addEntity("shulker", new ResourceLocation("minecraft:shulker"));
        SoulInit.addEntity("silverfish", new ResourceLocation("minecraft:silverfish"));
        SoulInit.addEntity("stray", new ResourceLocation("minecraft:stray"));
        SoulInit.addEntity("vex", new ResourceLocation("minecraft:vex"));
        SoulInit.addEntity("villager", new ResourceLocation("minecraft:villager"));
        SoulInit.addEntity("vindicator", new ResourceLocation("minecraft:vindicator"));
        SoulInit.addEntity("witch", new ResourceLocation("minecraft:witch"));
        SoulInit.addEntity("wolf", new ResourceLocation("minecraft:wolf"));
        SoulInit.addEntity("zombified_piglin", new ResourceLocation("minecraft:zombie_pigman"));
    }

    public static void init(IMobSoulTypeRegistry registry) {
        logger.info("Registering Souls");
        SoulInit.addSoul("bat");
        SoulInit.addSoul("cat");
        SoulInit.addSoul("dolphin");
        SoulInit.addSoul("horse");
        SoulInit.addSoul("drowned");
        SoulInit.addSoul("guardian");
        SoulInit.addSoul("endermite");
        SoulInit.addSoul("evoker");
        SoulInit.addSoul("fox");
        SoulInit.addSoul("husk");
        SoulInit.addSoul("llama");
        SoulInit.addSoul("magma_cube");
        SoulInit.addSoul("mooshroom");
        SoulInit.addSoul("panda");
        SoulInit.addSoul("parrot");
        SoulInit.addSoul("phantom");
        SoulInit.addSoul("piglin");
        SoulInit.addSoul("piglin_brute");
        SoulInit.addSoul("pillager");
        SoulInit.addSoul("polar_bear");
        SoulInit.addSoul("ravager");
        SoulInit.addSoul("shulker");
        SoulInit.addSoul("silverfish");
        SoulInit.addSoul("stray");
        SoulInit.addSoul("vex");
        SoulInit.addSoul("villager");
        SoulInit.addSoul("vindicator");
        SoulInit.addSoul("witch");
        SoulInit.addSoul("wolf");
        SoulInit.addSoul("zombie_piglin");
        SoulInit.register(registry);
    }

    private static void register(IMobSoulTypeRegistry registry) {
        for (Map.Entry<String, MobSoulType> entry : soulMap.entrySet()) {
            registry.register((IMobSoulType)entry.getValue());
        }
    }

    public static void addEntity(String name, ResourceLocation entity) {
        Set<Object> entities = new HashSet<ResourceLocation>();
        if (entityMap.containsKey(name)) {
            entities = entityMap.get(name);
            if (!entities.contains(entity)) {
                entities.add(entity);
                entityMap.put(name, entities);
            }
        } else {
            entities.add(entity);
            entityMap.put(name, entities);
        }
    }

    public static Set<ResourceLocation> getEntities(String name) {
        return entityMap.getOrDefault(name, new HashSet());
    }

    public static void addSoul(String name) {
        if (soulMap.containsKey(name)) {
            logger.info("Mob soul already has been registered");
            return;
        }
        int count = IndustrialAgriculture.config.getSoulQty(name);
        if (count < 1) {
            return;
        }
        soulMap.put(name, new MobSoulType(new ResourceLocation("industrialagriculture", name), SoulInit.getEntities(name), name, (double)count, ColorInit.getColor(name).intValue()));
    }

    public static MobSoulType getSoul(String name) {
        return soulMap.getOrDefault(name, new MobSoulType(new ResourceLocation("industrialagriculture"), new ResourceLocation("minecraft:bat"), name, 0.0, 0xFFFFFF));
    }
}

