/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.items;

import com.github.elrol.industrialagriculture.container.IACapabilityProviderSeedBag;
import com.github.elrol.industrialagriculture.container.IASeedBagContainer;
import com.github.elrol.industrialagriculture.container.ItemStackHandlerSeedBag;
import com.github.elrol.industrialagriculture.libs.TierRarity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SeedBag
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    int tier;
    int size = 16;
    private final String BASE_NBT_TAG = "base";
    private final String CAPABILITY_NBT_TAG = "cap";

    public SeedBag(int tier) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f));
        this.tier = tier;
    }

    @Nonnull
    public Rarity func_77613_e(@Nonnull ItemStack stack) {
        return TierRarity.get(this.tier);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ContainerPoviderSeedBag bagProvider = new ContainerPoviderSeedBag(this.tier, this.size, stack);
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)bagProvider, packetBuffer -> packetBuffer.writeInt(this.size));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        IItemHandler tileInventory;
        World world = ctx.func_195991_k();
        if (world.func_201670_d()) {
            return ActionResultType.PASS;
        }
        BlockPos pos = ctx.func_195995_a();
        Direction side = ctx.func_196000_l();
        ItemStack itemStack = ctx.func_195996_i();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return ActionResultType.PASS;
        }
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        LazyOptional capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        if (capability.isPresent()) {
            tileInventory = (IItemHandler)capability.orElseThrow(AssertionError::new);
        } else if (tileEntity instanceof IInventory) {
            tileInventory = new InvWrapper((IInventory)tileEntity);
        } else {
            return ActionResultType.FAIL;
        }
        ItemStackHandlerSeedBag itemStackHandlerSeedBag = SeedBag.getItemStackHandlerSeedBag(itemStack);
        for (int i = 0; i < itemStackHandlerSeedBag.getSlots(); ++i) {
            ItemStack seed = itemStackHandlerSeedBag.getStackInSlot(i);
            ItemStack seedsWhichDidNotFit = ItemHandlerHelper.insertItemStacked((IItemHandler)tileInventory, (ItemStack)seed, (boolean)false);
            itemStackHandlerSeedBag.setStackInSlot(i, seedsWhichDidNotFit);
        }
        tileEntity.func_70296_d();
        CompoundNBT nbt = itemStack.func_196082_o();
        int dirtyCounter = nbt.func_74762_e("dirtyCounter");
        nbt.func_74768_a("dirtyCounter", dirtyCounter + 1);
        itemStack.func_77982_d(nbt);
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new IACapabilityProviderSeedBag(this.tier, this.size);
    }

    private static ItemStackHandlerSeedBag getItemStackHandlerSeedBag(ItemStack itemStack) {
        IItemHandler flowerBag = (IItemHandler)itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (!(flowerBag instanceof ItemStackHandlerSeedBag)) {
            LOGGER.error("ItemFlowerBag did not have the expected ITEM_HANDLER_CAPABILITY");
            return new ItemStackHandlerSeedBag(1, 1);
        }
        return (ItemStackHandlerSeedBag)flowerBag;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT baseTag = stack.func_77978_p();
        ItemStackHandlerSeedBag stackHandler = SeedBag.getItemStackHandlerSeedBag(stack);
        CompoundNBT capabilityTag = stackHandler.serializeNBT();
        CompoundNBT combinedTag = new CompoundNBT();
        if (baseTag != null) {
            combinedTag.func_218657_a("base", (INBT)baseTag);
        }
        if (capabilityTag != null) {
            combinedTag.func_218657_a("cap", (INBT)capabilityTag);
        }
        return combinedTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt == null) {
            stack.func_77982_d(null);
            return;
        }
        CompoundNBT baseTag = nbt.func_74775_l("base");
        CompoundNBT capabilityTag = nbt.func_74775_l("cap");
        stack.func_77982_d(baseTag);
        ItemStackHandlerSeedBag stackHandler = SeedBag.getItemStackHandlerSeedBag(stack);
        stackHandler.deserializeNBT(capabilityTag);
    }

    public static float getFullnessPropertyOverride(ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
        ItemStackHandlerSeedBag seedBag = SeedBag.getItemStackHandlerSeedBag(stack);
        float fractionEmpty = (float)seedBag.getNumberOfEmptySlots() / (float)seedBag.getSlots();
        return 1.0f - fractionEmpty;
    }

    private static class ContainerPoviderSeedBag
    implements INamedContainerProvider {
        private final int tier;
        private final int size;
        private final ItemStack itemStackBag;

        public ContainerPoviderSeedBag(int tier, int size, ItemStack itemStackBag) {
            this.tier = tier;
            this.size = size;
            this.itemStackBag = itemStackBag;
        }

        @Nonnull
        public ITextComponent func_145748_c_() {
            return this.itemStackBag.func_151000_E();
        }

        @Nullable
        public Container createMenu(int windowID, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
            return IASeedBagContainer.createContainerServerSide(this.tier, this.size, windowID, playerInventory, SeedBag.getItemStackHandlerSeedBag(this.itemStackBag), this.itemStackBag);
        }
    }
}

