/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl;

import com.refinedmods.refinedstorage.api.IRSAPI;
import com.refinedmods.refinedstorage.api.RSAPIInject;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternRenderHandler;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementRegistry;
import com.refinedmods.refinedstorage.api.autocrafting.preview.ICraftingPreviewElementRegistry;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTaskRegistry;
import com.refinedmods.refinedstorage.api.network.INetworkManager;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridBehavior;
import com.refinedmods.refinedstorage.api.network.grid.IGridManager;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeManager;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeRegistry;
import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskManager;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskRegistry;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskSync;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorageProvider;
import com.refinedmods.refinedstorage.api.util.IComparer;
import com.refinedmods.refinedstorage.api.util.IQuantityFormatter;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementRegistry;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementRegistry;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.CraftingRequestInfo;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.CraftingTaskRegistry;
import com.refinedmods.refinedstorage.apiimpl.network.NetworkManager;
import com.refinedmods.refinedstorage.apiimpl.network.NetworkNodeManager;
import com.refinedmods.refinedstorage.apiimpl.network.NetworkNodeRegistry;
import com.refinedmods.refinedstorage.apiimpl.network.grid.CraftingGridBehavior;
import com.refinedmods.refinedstorage.apiimpl.network.grid.GridManager;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.FluidStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.ItemStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.StorageDiskManager;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.StorageDiskRegistry;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.StorageDiskSync;
import com.refinedmods.refinedstorage.apiimpl.util.Comparer;
import com.refinedmods.refinedstorage.apiimpl.util.FluidStackList;
import com.refinedmods.refinedstorage.apiimpl.util.ItemStackList;
import com.refinedmods.refinedstorage.apiimpl.util.QuantityFormatter;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class API
implements IRSAPI {
    private static final Logger LOGGER = LogManager.getLogger(API.class);
    private static final IRSAPI INSTANCE = new API();
    private final IComparer comparer = new Comparer();
    private final IQuantityFormatter quantityFormatter = new QuantityFormatter();
    private final INetworkNodeRegistry networkNodeRegistry = new NetworkNodeRegistry();
    private final ICraftingTaskRegistry craftingTaskRegistry = new CraftingTaskRegistry();
    private final ICraftingMonitorElementRegistry craftingMonitorElementRegistry = new CraftingMonitorElementRegistry();
    private final ICraftingPreviewElementRegistry craftingPreviewElementRegistry = new CraftingPreviewElementRegistry();
    private final IGridManager gridManager = new GridManager();
    private final ICraftingGridBehavior craftingGridBehavior = new CraftingGridBehavior();
    private final IStorageDiskRegistry storageDiskRegistry = new StorageDiskRegistry();
    private final IStorageDiskSync storageDiskSync = new StorageDiskSync();
    private final Map<StorageType, TreeSet<IExternalStorageProvider<?>>> externalStorageProviders = new EnumMap(StorageType.class);
    private final List<ICraftingPatternRenderHandler> patternRenderHandlers = new LinkedList<ICraftingPatternRenderHandler>();

    public static IRSAPI instance() {
        return INSTANCE;
    }

    public static void deliver() {
        Type annotationType = Type.getType(RSAPIInject.class);
        List annotations = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> annotationType.equals((Object)a.getAnnotationType())).collect(Collectors.toList());
        LOGGER.info("Found {} RS API injection {}", (Object)annotations.size(), (Object)(annotations.size() == 1 ? "point" : "points"));
        for (ModFileScanData.AnnotationData annotation : annotations) {
            try {
                Class<?> clazz = Class.forName(annotation.getClassType().getClassName());
                Field field = clazz.getField(annotation.getMemberName());
                if (field.getType() == IRSAPI.class) {
                    field.set(null, INSTANCE);
                }
                LOGGER.info("Injected RS API in {} {}", (Object)annotation.getClassType().getClassName(), (Object)annotation.getMemberName());
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOGGER.error("Could not inject RS API in {} {}", (Object)annotation.getClassType().getClassName(), (Object)annotation.getMemberName(), (Object)e);
            }
        }
    }

    @Override
    @Nonnull
    public IComparer getComparer() {
        return this.comparer;
    }

    @Override
    @Nonnull
    public IQuantityFormatter getQuantityFormatter() {
        return this.quantityFormatter;
    }

    @Override
    @Nonnull
    public INetworkNodeRegistry getNetworkNodeRegistry() {
        return this.networkNodeRegistry;
    }

    @Override
    public INetworkNodeManager getNetworkNodeManager(ServerWorld world) {
        return (INetworkNodeManager)world.func_217481_x().func_215752_a(() -> new NetworkNodeManager("refinedstorage_nodes", (World)world), "refinedstorage_nodes");
    }

    @Override
    public INetworkManager getNetworkManager(ServerWorld world) {
        return (INetworkManager)world.func_217481_x().func_215752_a(() -> new NetworkManager("refinedstorage_networks", (World)world), "refinedstorage_networks");
    }

    @Override
    @Nonnull
    public ICraftingTaskRegistry getCraftingTaskRegistry() {
        return this.craftingTaskRegistry;
    }

    @Override
    @Nonnull
    public ICraftingMonitorElementRegistry getCraftingMonitorElementRegistry() {
        return this.craftingMonitorElementRegistry;
    }

    @Override
    @Nonnull
    public ICraftingPreviewElementRegistry getCraftingPreviewElementRegistry() {
        return this.craftingPreviewElementRegistry;
    }

    @Override
    @Nonnull
    public IStackList<ItemStack> createItemStackList() {
        return new ItemStackList();
    }

    @Override
    @Nonnull
    public IStackList<FluidStack> createFluidStackList() {
        return new FluidStackList();
    }

    @Override
    @Nonnull
    public ICraftingMonitorElementList createCraftingMonitorElementList() {
        return new CraftingMonitorElementList();
    }

    @Override
    @Nonnull
    public IGridManager getGridManager() {
        return this.gridManager;
    }

    @Override
    @Nonnull
    public ICraftingGridBehavior getCraftingGridBehavior() {
        return this.craftingGridBehavior;
    }

    @Override
    @Nonnull
    public IStorageDiskRegistry getStorageDiskRegistry() {
        return this.storageDiskRegistry;
    }

    @Override
    @Nonnull
    public IStorageDiskManager getStorageDiskManager(ServerWorld anyWorld) {
        ServerWorld world = anyWorld.func_73046_m().func_241755_D_();
        return (IStorageDiskManager)world.func_217481_x().func_215752_a(() -> new StorageDiskManager("refinedstorage_disks", world), "refinedstorage_disks");
    }

    @Override
    @Nonnull
    public IStorageDiskSync getStorageDiskSync() {
        return this.storageDiskSync;
    }

    @Override
    public void addExternalStorageProvider(StorageType type, IExternalStorageProvider<?> provider) {
        this.externalStorageProviders.computeIfAbsent(type, k -> new TreeSet((a, b) -> Integer.compare(b.getPriority(), a.getPriority()))).add(provider);
    }

    public Set<IExternalStorageProvider<?>> getExternalStorageProviders(StorageType type) {
        TreeSet<IExternalStorageProvider<?>> providers = this.externalStorageProviders.get((Object)type);
        return providers == null ? Collections.emptySet() : providers;
    }

    @Override
    @Nonnull
    public IStorageDisk<ItemStack> createDefaultItemDisk(ServerWorld world, int capacity, @Nullable PlayerEntity owner) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        return new ItemStorageDisk(world, capacity, owner == null ? null : owner.func_146103_bH().getId());
    }

    @Override
    @Nonnull
    public IStorageDisk<FluidStack> createDefaultFluidDisk(ServerWorld world, int capacity, @Nullable PlayerEntity owner) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        return new FluidStorageDisk(world, capacity, owner == null ? null : owner.func_146103_bH().getId());
    }

    @Override
    public ICraftingRequestInfo createCraftingRequestInfo(ItemStack stack, int count) {
        return new CraftingRequestInfo(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)count));
    }

    @Override
    public ICraftingRequestInfo createCraftingRequestInfo(FluidStack stack, int count) {
        return new CraftingRequestInfo(StackUtils.copy(stack, count));
    }

    @Override
    public ICraftingRequestInfo createCraftingRequestInfo(CompoundNBT tag) throws CraftingTaskReadException {
        return new CraftingRequestInfo(tag);
    }

    @Override
    public void addPatternRenderHandler(ICraftingPatternRenderHandler renderHandler) {
        this.patternRenderHandlers.add(renderHandler);
    }

    @Override
    public List<ICraftingPatternRenderHandler> getPatternRenderHandlers() {
        return this.patternRenderHandlers;
    }

    @Override
    public int getItemStackHashCode(ItemStack stack) {
        int result = stack.func_77973_b().hashCode();
        if (stack.func_77942_o()) {
            result = this.getHashCode(stack.func_77978_p(), result);
        }
        return result;
    }

    private int getHashCode(INBT tag, int result) {
        result = tag instanceof CompoundNBT ? this.getHashCode((CompoundNBT)tag, result) : (tag instanceof ListNBT ? this.getHashCode((ListNBT)tag, result) : 31 * result + tag.hashCode());
        return result;
    }

    private int getHashCode(CompoundNBT tag, int result) {
        for (String key : tag.func_150296_c()) {
            result = 31 * result + key.hashCode();
            result = this.getHashCode(tag.func_74781_a(key), result);
        }
        return result;
    }

    private int getHashCode(ListNBT tag, int result) {
        for (INBT tagItem : tag) {
            result = this.getHashCode(tagItem, result);
        }
        return result;
    }

    @Override
    public int getFluidStackHashCode(FluidStack stack) {
        int result = stack.getFluid().hashCode();
        if (stack.getTag() != null) {
            result = this.getHashCode(stack.getTag(), result);
        }
        return result;
    }
}

