/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;

public class SerializationUtil {
    private static final String NBT_PATTERN_STACK = "Stack";
    private static final String NBT_PATTERN_CONTAINER_POS = "ContainerPos";

    private SerializationUtil() {
    }

    public static ListNBT writeItemStackList(IStackList<ItemStack> stacks) {
        ListNBT list = new ListNBT();
        for (StackListEntry<ItemStack> entry : stacks.getStacks()) {
            list.add((Object)StackUtils.serializeStackToNbt(entry.getStack()));
        }
        return list;
    }

    public static IStackList<ItemStack> readItemStackList(ListNBT list) throws CraftingTaskReadException {
        IStackList<ItemStack> stacks = API.instance().createItemStackList();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = StackUtils.deserializeStackFromNbt(list.func_150305_b(i));
            if (stack.func_190926_b()) {
                throw new CraftingTaskReadException("Empty stack!");
            }
            stacks.add(stack);
        }
        return stacks;
    }

    public static ListNBT writeFluidStackList(IStackList<FluidStack> stacks) {
        ListNBT list = new ListNBT();
        for (StackListEntry<FluidStack> entry : stacks.getStacks()) {
            list.add((Object)entry.getStack().writeToNBT(new CompoundNBT()));
        }
        return list;
    }

    public static IStackList<FluidStack> readFluidStackList(ListNBT list) throws CraftingTaskReadException {
        IStackList<FluidStack> stacks = API.instance().createFluidStackList();
        for (int i = 0; i < list.size(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)list.func_150305_b(i));
            if (stack.isEmpty()) {
                throw new CraftingTaskReadException("Empty stack!");
            }
            stacks.add(stack);
        }
        return stacks;
    }

    public static CompoundNBT writePatternToNbt(ICraftingPattern pattern) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(NBT_PATTERN_STACK, (INBT)pattern.getStack().serializeNBT());
        tag.func_74772_a(NBT_PATTERN_CONTAINER_POS, pattern.getContainer().getPosition().func_218275_a());
        return tag;
    }

    public static ICraftingPattern readPatternFromNbt(CompoundNBT tag, World world) throws CraftingTaskReadException {
        BlockPos containerPos = BlockPos.func_218283_e((long)tag.func_74763_f(NBT_PATTERN_CONTAINER_POS));
        INetworkNode node = API.instance().getNetworkNodeManager((ServerWorld)world).getNode(containerPos);
        if (node instanceof ICraftingPatternContainer) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(NBT_PATTERN_STACK));
            if (stack.func_77973_b() instanceof ICraftingPatternProvider) {
                return ((ICraftingPatternProvider)stack.func_77973_b()).create(world, stack, (ICraftingPatternContainer)((Object)node));
            }
            throw new CraftingTaskReadException("Pattern stack is not a crafting pattern provider");
        }
        throw new CraftingTaskReadException("Crafting pattern container doesn't exist anymore");
    }
}

