/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.IoUtil;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.Node;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeListener;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class CraftingNode
extends Node {
    private static final String NBT_RECIPE = "Recipe";
    private final NonNullList<ItemStack> recipe;

    public CraftingNode(ICraftingPattern pattern, boolean root, NonNullList<ItemStack> recipe) {
        super(pattern, root);
        this.recipe = recipe;
    }

    public CraftingNode(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        super(network, tag);
        this.recipe = NonNullList.func_191196_a();
        ListNBT tookList = tag.func_150295_c(NBT_RECIPE, 10);
        for (int i = 0; i < tookList.size(); ++i) {
            this.recipe.add((Object)StackUtils.deserializeStackFromNbt(tookList.func_150305_b(i)));
        }
    }

    @Override
    public void update(INetwork network, int ticks, NodeList nodes, IStorageDisk<ItemStack> internalStorage, IStorageDisk<FluidStack> internalFluidStorage, NodeListener listener) {
        for (ICraftingPatternContainer container : network.getCraftingManager().getAllContainers(this.getPattern())) {
            int interval = container.getUpdateInterval();
            if (interval < 0) {
                throw new IllegalStateException(container + " has an update interval of < 0");
            }
            if (interval != 0 && ticks % interval != 0) continue;
            for (int i = 0; i < container.getMaximumSuccessfulCraftingUpdates() && IoUtil.extractFromInternalItemStorage(this.requirements.getSingleItemRequirementSet(true), internalStorage, Action.SIMULATE) != null; ++i) {
                IoUtil.extractFromInternalItemStorage(this.requirements.getSingleItemRequirementSet(false), internalStorage, Action.PERFORM);
                ItemStack output = this.getPattern().getOutput(this.recipe);
                if (!this.isRoot()) {
                    internalStorage.insert(output, output.func_190916_E(), Action.PERFORM);
                } else {
                    ItemStack remainder = network.insertItem(output, output.func_190916_E(), Action.PERFORM);
                    internalStorage.insert(remainder, remainder.func_190916_E(), Action.PERFORM);
                }
                for (ItemStack byp : this.getPattern().getByproducts(this.recipe)) {
                    internalStorage.insert(byp, byp.func_190916_E(), Action.PERFORM);
                }
                this.next();
                listener.onSingleDone(this);
                if (this.getQuantity() > 0) continue;
                listener.onAllDone(this);
                return;
            }
        }
    }

    @Override
    public CompoundNBT writeToNbt() {
        CompoundNBT tag = super.writeToNbt();
        ListNBT tookList = new ListNBT();
        for (ItemStack took : this.recipe) {
            tookList.add((Object)StackUtils.serializeStackToNbt(took));
        }
        tag.func_218657_a(NBT_RECIPE, (INBT)tookList);
        return tag;
    }
}

