/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridBehavior;
import com.refinedmods.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingGridBehavior
implements ICraftingGridBehavior {
    @Override
    public void onCrafted(INetworkAwareGrid grid, ICraftingRecipe recipe, PlayerEntity player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
        NonNullList remainder = recipe.func_179532_b((IInventory)grid.getCraftingMatrix());
        INetwork network = grid.getNetwork();
        CraftingInventory matrix = grid.getCraftingMatrix();
        for (int i = 0; i < grid.getCraftingMatrix().func_70302_i_(); ++i) {
            ItemStack slot = matrix.func_70301_a(i);
            if (i < remainder.size() && !((ItemStack)remainder.get(i)).func_190926_b()) {
                if (!slot.func_190926_b() && slot.func_190916_E() > 1) {
                    if (!player.field_71071_by.func_70441_a(((ItemStack)remainder.get(i)).func_77946_l())) {
                        ItemStack remainderStack;
                        ItemStack itemStack = remainderStack = network == null ? ((ItemStack)remainder.get(i)).func_77946_l() : network.insertItem(((ItemStack)remainder.get(i)).func_77946_l(), ((ItemStack)remainder.get(i)).func_190916_E(), Action.PERFORM);
                        if (!remainderStack.func_190926_b()) {
                            InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)remainderStack);
                        }
                    }
                    matrix.func_70298_a(i, 1);
                    continue;
                }
                matrix.func_70299_a(i, ((ItemStack)remainder.get(i)).func_77946_l());
                continue;
            }
            if (slot.func_190926_b()) continue;
            if (slot.func_190916_E() == 1 && network != null && grid.isGridActive()) {
                ItemStack refill;
                if (availableItems == null) {
                    refill = network.extractItem(slot, 1, Action.PERFORM);
                } else if (availableItems.get(slot) != null) {
                    refill = availableItems.remove(slot, 1).getStack().func_77946_l();
                    refill.func_190920_e(1);
                    usedItems.add(refill);
                } else {
                    refill = ItemStack.field_190927_a;
                }
                matrix.func_70299_a(i, refill);
                if (refill.func_190926_b()) continue;
                network.getItemStorageTracker().changed(player, refill.func_77946_l());
                continue;
            }
            matrix.func_70298_a(i, 1);
        }
        grid.onCraftingMatrixChanged();
    }

    @Override
    public void onCraftedShift(INetworkAwareGrid grid, PlayerEntity player) {
        CraftingInventory matrix = grid.getCraftingMatrix();
        INetwork network = grid.getNetwork();
        ArrayList<ItemStack> craftedItemsList = new ArrayList<ItemStack>();
        ItemStack crafted = grid.getCraftingResult().func_70301_a(0);
        int maxCrafted = crafted.func_77976_d();
        int amountCrafted = 0;
        boolean useNetwork = network != null && grid.isGridActive();
        IStackList<ItemStack> availableItems = API.instance().createItemStackList();
        if (useNetwork) {
            this.filterDuplicateStacks(network, matrix, availableItems);
        }
        IStackList<ItemStack> usedItems = API.instance().createItemStackList();
        ForgeHooks.setCraftingPlayer((PlayerEntity)player);
        do {
            grid.onCrafted(player, availableItems, usedItems);
            craftedItemsList.add(crafted.func_77946_l());
        } while (API.instance().getComparer().isEqual(crafted, grid.getCraftingResult().func_70301_a(0)) && (amountCrafted += crafted.func_190916_E()) < maxCrafted && amountCrafted + crafted.func_190916_E() <= maxCrafted);
        if (useNetwork) {
            usedItems.getStacks().forEach(stack -> network.extractItem((ItemStack)stack.getStack(), ((ItemStack)stack.getStack()).func_190916_E(), Action.PERFORM));
        }
        for (ItemStack craftedItem : craftedItemsList) {
            if (player.field_71071_by.func_70441_a(craftedItem.func_77946_l())) continue;
            ItemStack remainder = craftedItem;
            if (useNetwork) {
                remainder = network.insertItem(craftedItem, craftedItem.func_190916_E(), Action.PERFORM);
            }
            if (remainder.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)remainder);
        }
        crafted.func_77980_a(player.field_70170_p, player, amountCrafted);
        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)crafted, (int)amountCrafted), (IInventory)grid.getCraftingMatrix());
        ForgeHooks.setCraftingPlayer(null);
    }

    private void filterDuplicateStacks(INetwork network, CraftingInventory matrix, IStackList<ItemStack> availableItems) {
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            ItemStack stack = network.getItemStorageCache().getList().get(matrix.func_70301_a(i));
            if (stack == null || availableItems.get(stack) != null) continue;
            availableItems.add(stack);
        }
    }

    @Override
    public void onRecipeTransfer(INetworkAwareGrid grid, PlayerEntity player, ItemStack[][] recipe) {
        int i;
        INetwork network = grid.getNetwork();
        if (network != null && grid.getGridType() == GridType.CRAFTING && !network.getSecurityManager().hasPermission(Permission.EXTRACT, player)) {
            return;
        }
        for (i = 0; i < grid.getCraftingMatrix().func_70302_i_(); ++i) {
            ItemStack slot = grid.getCraftingMatrix().func_70301_a(i);
            if (slot.func_190926_b()) continue;
            if (grid.getGridType() == GridType.CRAFTING) {
                if (network != null && grid.isGridActive()) {
                    if (!network.insertItem(slot, slot.func_190916_E(), Action.SIMULATE).func_190926_b()) {
                        return;
                    }
                    network.insertItem(slot, slot.func_190916_E(), Action.PERFORM);
                    network.getItemStorageTracker().changed(player, slot.func_77946_l());
                } else if (!player.field_71071_by.func_70441_a(slot.func_77946_l())) {
                    return;
                }
            }
            grid.getCraftingMatrix().func_70299_a(i, ItemStack.field_190927_a);
        }
        block1: for (i = 0; i < grid.getCraftingMatrix().func_70302_i_(); ++i) {
            if (recipe[i] == null) continue;
            ItemStack[] possibilities = recipe[i];
            if (grid.getGridType() == GridType.CRAFTING) {
                boolean found = false;
                if (network != null && grid.isGridActive()) {
                    for (ItemStack possibility : possibilities) {
                        ItemStack took = network.extractItem(possibility, 1, 1, Action.PERFORM);
                        if (took.func_190926_b()) continue;
                        grid.getCraftingMatrix().func_70299_a(i, took);
                        network.getItemStorageTracker().changed(player, took.func_77946_l());
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                for (ItemStack possibility : possibilities) {
                    for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
                        if (!API.instance().getComparer().isEqual(possibility, player.field_71071_by.func_70301_a(j), 1)) continue;
                        grid.getCraftingMatrix().func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)player.field_71071_by.func_70301_a(j), (int)1));
                        player.field_71071_by.func_70298_a(j, 1);
                        found = true;
                        break;
                    }
                    if (found) continue block1;
                }
                continue;
            }
            if (grid.getGridType() != GridType.PATTERN) continue;
            grid.getCraftingMatrix().func_70299_a(i, possibilities.length == 0 ? ItemStack.field_190927_a : possibilities[0]);
        }
        if (grid.getGridType() == GridType.PATTERN) {
            ((GridNetworkNode)grid).setProcessingPattern(false);
            ((GridNetworkNode)grid).markDirty();
        }
    }
}

