/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.AllowedTagList;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.FluidGridStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.ItemGridStorageCacheListener;
import com.refinedmods.refinedstorage.block.GridBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.FilterItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.ItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.PatternItem;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.data.TileDataManager;
import com.refinedmods.refinedstorage.tile.grid.GridTile;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class GridNetworkNode
extends NetworkNode
implements INetworkAwareGrid,
IType {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "grid");
    public static final ResourceLocation CRAFTING_ID = new ResourceLocation("refinedstorage", "crafting_grid");
    public static final ResourceLocation PATTERN_ID = new ResourceLocation("refinedstorage", "pattern_grid");
    public static final ResourceLocation FLUID_ID = new ResourceLocation("refinedstorage", "fluid_grid");
    public static final String NBT_VIEW_TYPE = "ViewType";
    public static final String NBT_SORTING_DIRECTION = "SortingDirection";
    public static final String NBT_SORTING_TYPE = "SortingType";
    public static final String NBT_SEARCH_BOX_MODE = "SearchBoxMode";
    private static final String NBT_EXACT_MODE = "Exact";
    public static final String NBT_TAB_SELECTED = "TabSelected";
    public static final String NBT_TAB_PAGE = "TabPage";
    public static final String NBT_SIZE = "Size";
    private static final String NBT_PROCESSING_PATTERN = "ProcessingPattern";
    private static final String NBT_PROCESSING_TYPE = "ProcessingType";
    private static final String NBT_PROCESSING_MATRIX_FLUIDS = "ProcessingMatrixFluids";
    private static final String NBT_ALLOWED_TAGS = "AllowedTags";
    private final AllowedTagList allowedTagList = new AllowedTagList(this::updateAllowedTags);
    private final Container craftingContainer = new Container(ContainerType.field_221518_l, 0){

        public boolean func_75145_c(PlayerEntity player) {
            return false;
        }

        public void func_75130_a(IInventory inventory) {
            if (!GridNetworkNode.this.world.field_72995_K) {
                GridNetworkNode.this.onCraftingMatrixChanged();
            }
        }
    };
    private ICraftingRecipe currentRecipe;
    private final CraftingInventory matrix = new CraftingInventory(this.craftingContainer, 3, 3);
    private final CraftResultInventory result = new CraftResultInventory();
    private final BaseItemHandler processingMatrix = new BaseItemHandler(18).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!reading && slot < 9) {
            this.allowedTagList.clearItemTags(slot);
        }
    });
    private final FluidInventory processingMatrixFluids = new FluidInventory(18, 64000).addListener(new NetworkNodeFluidInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!reading && slot < 9) {
            this.allowedTagList.clearFluidTags(slot);
        }
    });
    private boolean readingInventory;
    private final Set<ICraftingGridListener> craftingListeners = new HashSet<ICraftingGridListener>();
    private final BaseItemHandler patterns = new BaseItemHandler(2){

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 0 || stack.func_77978_p() != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    }.addValidator(new ItemValidator((Item)RSItems.PATTERN.get())).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        ItemStack pattern = handler.getStackInSlot(slot);
        if (!reading && slot == 1 && !pattern.func_190926_b()) {
            boolean processing = PatternItem.isProcessing(pattern);
            if (processing) {
                int i;
                for (i = 0; i < 9; ++i) {
                    this.processingMatrix.setStackInSlot(i, PatternItem.getInputSlot(pattern, i));
                    this.processingMatrixFluids.setFluid(i, PatternItem.getFluidInputSlot(pattern, i));
                }
                for (i = 0; i < 9; ++i) {
                    this.processingMatrix.setStackInSlot(9 + i, PatternItem.getOutputSlot(pattern, i));
                    this.processingMatrixFluids.setFluid(9 + i, PatternItem.getFluidOutputSlot(pattern, i));
                }
                AllowedTagList allowedTagsFromPattern = PatternItem.getAllowedTags(pattern);
                if (allowedTagsFromPattern != null) {
                    this.allowedTagList.setAllowedItemTags(allowedTagsFromPattern.getAllowedItemTags());
                    this.allowedTagList.setAllowedFluidTags(allowedTagsFromPattern.getAllowedFluidTags());
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    this.matrix.func_70299_a(i, PatternItem.getInputSlot(pattern, i));
                }
            }
            this.setProcessingPattern(processing);
            this.markDirty();
        }
    });
    private final List<IFilter> filters = new ArrayList<IFilter>();
    private final List<IGridTab> tabs = new ArrayList<IGridTab>();
    private final FilterItemHandler filter = (FilterItemHandler)new FilterItemHandler(this.filters, this.tabs).addListener(new NetworkNodeInventoryListener(this));
    private final GridType type;
    private int viewType = 0;
    private int sortingDirection = 1;
    private int sortingType = 0;
    private int searchBoxMode = 0;
    private int size = 0;
    private int tabSelected = -1;
    private int tabPage = 0;
    private boolean exactPattern = true;
    private boolean processingPattern = false;
    private int processingType = 0;

    public GridNetworkNode(World world, BlockPos pos, GridType type) {
        super(world, pos);
        this.type = type;
    }

    public static ResourceLocation getId(GridType type) {
        switch (type) {
            case NORMAL: {
                return ID;
            }
            case CRAFTING: {
                return CRAFTING_ID;
            }
            case PATTERN: {
                return PATTERN_ID;
            }
            case FLUID: {
                return FLUID_ID;
            }
        }
        throw new IllegalArgumentException("Unknown grid type " + (Object)((Object)type));
    }

    public AllowedTagList getAllowedTagList() {
        return this.allowedTagList;
    }

    private void updateAllowedTags() {
        this.markDirty();
        TileEntity tile = this.world.func_175625_s(this.pos);
        if (tile instanceof GridTile) {
            ((GridTile)tile).getDataManager().sendParameterToWatchers(GridTile.ALLOWED_ITEM_TAGS);
            ((GridTile)tile).getDataManager().sendParameterToWatchers(GridTile.ALLOWED_FLUID_TAGS);
        }
    }

    @Override
    public int getEnergyUsage() {
        switch (this.type) {
            case NORMAL: {
                return RS.SERVER_CONFIG.getGrid().getGridUsage();
            }
            case CRAFTING: {
                return RS.SERVER_CONFIG.getGrid().getCraftingGridUsage();
            }
            case PATTERN: {
                return RS.SERVER_CONFIG.getGrid().getPatternGridUsage();
            }
            case FLUID: {
                return RS.SERVER_CONFIG.getGrid().getFluidGridUsage();
            }
        }
        return 0;
    }

    public void setViewType(int viewType) {
        this.viewType = viewType;
    }

    public void setSortingDirection(int sortingDirection) {
        this.sortingDirection = sortingDirection;
    }

    public void setSortingType(int sortingType) {
        this.sortingType = sortingType;
    }

    public void setSearchBoxMode(int searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    public void setTabSelected(int tabSelected) {
        this.tabSelected = tabSelected;
    }

    public void setTabPage(int page) {
        this.tabPage = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isExactPattern() {
        return this.exactPattern;
    }

    public void setExactPattern(boolean exactPattern) {
        this.exactPattern = exactPattern;
    }

    public boolean isProcessingPattern() {
        return this.world.field_72995_K ? GridTile.PROCESSING_PATTERN.getValue() : this.processingPattern;
    }

    public void setProcessingPattern(boolean processingPattern) {
        this.processingPattern = processingPattern;
    }

    @Override
    public GridType getGridType() {
        return this.type;
    }

    @Override
    public IStorageCacheListener createListener(ServerPlayerEntity player) {
        return this.type == GridType.FLUID ? new FluidGridStorageCacheListener(player, this.network) : new ItemGridStorageCacheListener(player, this.network);
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        if (this.network != null) {
            return this.type == GridType.FLUID ? this.network.getFluidStorageCache() : this.network.getItemStorageCache();
        }
        return null;
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.network != null ? this.network.getItemGridHandler() : null;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        return this.network != null ? this.network.getFluidGridHandler() : null;
    }

    @Override
    public void addCraftingListener(ICraftingGridListener listener) {
        this.craftingListeners.add(listener);
    }

    @Override
    public void removeCraftingListener(ICraftingGridListener listener) {
        this.craftingListeners.remove(listener);
    }

    @Override
    public ITextComponent getTitle() {
        switch (this.type) {
            case CRAFTING: {
                return new TranslationTextComponent("gui.refinedstorage.crafting_grid");
            }
            case PATTERN: {
                return new TranslationTextComponent("gui.refinedstorage.pattern_grid");
            }
            case FLUID: {
                return new TranslationTextComponent("gui.refinedstorage.fluid_grid");
            }
        }
        return new TranslationTextComponent("gui.refinedstorage.grid");
    }

    public IItemHandler getPatterns() {
        return this.patterns;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public CraftingInventory getCraftingMatrix() {
        return this.matrix;
    }

    @Override
    public CraftResultInventory getCraftingResult() {
        return this.result;
    }

    public BaseItemHandler getProcessingMatrix() {
        return this.processingMatrix;
    }

    public FluidInventory getProcessingMatrixFluids() {
        return this.processingMatrixFluids;
    }

    @Override
    public void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((IInventory)this.matrix, this.world)) {
            this.currentRecipe = this.world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.matrix, this.world).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.result.func_70299_a(0, ItemStack.field_190927_a);
        } else {
            this.result.func_70299_a(0, this.currentRecipe.func_77572_b((IInventory)this.matrix));
        }
        this.craftingListeners.forEach(ICraftingGridListener::onCraftingMatrixChanged);
        if (!this.readingInventory) {
            this.markDirty();
        }
    }

    @Override
    public void onRecipeTransfer(PlayerEntity player, ItemStack[][] recipe) {
        API.instance().getCraftingGridBehavior().onRecipeTransfer(this, player, recipe);
    }

    public void clearMatrix() {
        int i;
        for (i = 0; i < this.processingMatrix.getSlots(); ++i) {
            this.processingMatrix.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < this.processingMatrixFluids.getSlots(); ++i) {
            this.processingMatrixFluids.setFluid(i, FluidStack.EMPTY);
        }
        for (i = 0; i < this.matrix.func_70302_i_(); ++i) {
            this.matrix.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public void onClosed(PlayerEntity player) {
    }

    @Override
    public boolean isGridActive() {
        BlockState state = this.world.func_180495_p(this.pos);
        if (state.func_177230_c() instanceof GridBlock) {
            return (Boolean)state.func_177229_b((Property)NetworkNodeBlock.CONNECTED);
        }
        return false;
    }

    @Override
    public int getSlotId() {
        return -1;
    }

    @Override
    public void onCrafted(PlayerEntity player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
        API.instance().getCraftingGridBehavior().onCrafted(this, this.currentRecipe, player, availableItems, usedItems);
    }

    @Override
    public void onClear(PlayerEntity player) {
        if (this.type == GridType.CRAFTING) {
            if (this.network != null && this.network.canRun() && this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
                for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
                    ItemStack slot = this.matrix.func_70301_a(i);
                    if (slot.func_190926_b()) continue;
                    this.matrix.func_70299_a(i, this.network.insertItem(slot, slot.func_190916_E(), Action.PERFORM));
                    this.network.getItemStorageTracker().changed(player, slot.func_77946_l());
                }
            } else {
                for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
                    ItemStack slot = this.matrix.func_70301_a(i);
                    if (!slot.func_190926_b()) {
                        player.field_71071_by.func_70441_a(this.matrix.func_70301_a(i));
                    }
                    this.onCraftingMatrixChanged();
                }
            }
        } else if (this.type == GridType.PATTERN) {
            this.clearMatrix();
        }
    }

    @Override
    public void onCraftedShift(PlayerEntity player) {
        API.instance().getCraftingGridBehavior().onCraftedShift(this, player);
    }

    public void onCreatePattern() {
        if (this.canCreatePattern()) {
            if (this.patterns.getStackInSlot(1).func_190926_b()) {
                this.patterns.extractItem(0, 1, false);
            }
            ItemStack pattern = new ItemStack((IItemProvider)RSItems.PATTERN.get());
            PatternItem.setToCurrentVersion(pattern);
            PatternItem.setProcessing(pattern, this.processingPattern);
            if (!this.processingPattern) {
                PatternItem.setExact(pattern, this.exactPattern);
            } else {
                PatternItem.setAllowedTags(pattern, this.allowedTagList);
            }
            if (this.processingPattern) {
                for (int i = 0; i < 18; ++i) {
                    FluidStack fluid;
                    if (!this.processingMatrix.getStackInSlot(i).func_190926_b()) {
                        if (i >= 9) {
                            PatternItem.setOutputSlot(pattern, i - 9, this.processingMatrix.getStackInSlot(i));
                        } else {
                            PatternItem.setInputSlot(pattern, i, this.processingMatrix.getStackInSlot(i));
                        }
                    }
                    if ((fluid = this.processingMatrixFluids.getFluid(i)).isEmpty()) continue;
                    if (i >= 9) {
                        PatternItem.setFluidOutputSlot(pattern, i - 9, fluid);
                        continue;
                    }
                    PatternItem.setFluidInputSlot(pattern, i, fluid);
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    ItemStack ingredient = this.matrix.func_70301_a(i);
                    if (ingredient.func_190926_b()) continue;
                    PatternItem.setInputSlot(pattern, i, ingredient);
                }
            }
            this.patterns.setStackInSlot(1, pattern);
        }
    }

    private boolean isPatternAvailable() {
        return !this.patterns.getStackInSlot(0).func_190926_b() || !this.patterns.getStackInSlot(1).func_190926_b();
    }

    public boolean canCreatePattern() {
        if (!this.isPatternAvailable()) {
            return false;
        }
        if (this.isProcessingPattern()) {
            int i;
            int inputsFilled = 0;
            int outputsFilled = 0;
            for (i = 0; i < 9; ++i) {
                if (!this.processingMatrix.getStackInSlot(i).func_190926_b()) {
                    ++inputsFilled;
                }
                if (this.processingMatrixFluids.getFluid(i).isEmpty()) continue;
                ++inputsFilled;
            }
            for (i = 9; i < 18; ++i) {
                if (!this.processingMatrix.getStackInSlot(i).func_190926_b()) {
                    ++outputsFilled;
                }
                if (this.processingMatrixFluids.getFluid(i).isEmpty()) continue;
                ++outputsFilled;
            }
            return inputsFilled > 0 && outputsFilled > 0;
        }
        return !this.result.func_70301_a(0).func_190926_b() && this.isPatternAvailable();
    }

    @Override
    public int getViewType() {
        return this.world.field_72995_K ? GridTile.VIEW_TYPE.getValue() : this.viewType;
    }

    @Override
    public int getSortingDirection() {
        return this.world.field_72995_K ? GridTile.SORTING_DIRECTION.getValue() : this.sortingDirection;
    }

    @Override
    public int getSortingType() {
        return this.world.field_72995_K ? GridTile.SORTING_TYPE.getValue() : this.sortingType;
    }

    @Override
    public int getSearchBoxMode() {
        return this.world.field_72995_K ? GridTile.SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    @Override
    public int getSize() {
        return this.world.field_72995_K ? GridTile.SIZE.getValue() : this.size;
    }

    @Override
    public int getTabSelected() {
        return this.world.field_72995_K ? GridTile.TAB_SELECTED.getValue() : this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.world.field_72995_K ? GridTile.TAB_PAGE.getValue() : Math.min(this.tabPage, this.getTotalTabPages());
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 5.0f);
    }

    @Override
    public void onViewTypeChanged(int type) {
        TileDataManager.setParameter(GridTile.VIEW_TYPE, type);
    }

    @Override
    public void onSortingTypeChanged(int type) {
        TileDataManager.setParameter(GridTile.SORTING_TYPE, type);
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        TileDataManager.setParameter(GridTile.SORTING_DIRECTION, direction);
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        TileDataManager.setParameter(GridTile.SEARCH_BOX_MODE, searchBoxMode);
    }

    @Override
    public void onSizeChanged(int size) {
        TileDataManager.setParameter(GridTile.SIZE, size);
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        TileDataManager.setParameter(GridTile.TAB_SELECTED, tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            TileDataManager.setParameter(GridTile.TAB_PAGE, page);
        }
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? GridTile.PROCESSING_TYPE.getValue() : this.processingType;
    }

    @Override
    public void setType(int type) {
        this.processingType = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.getProcessingMatrix();
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.getProcessingMatrixFluids();
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_ALLOWED_TAGS)) {
            this.allowedTagList.readFromNbt(tag.func_74775_l(NBT_ALLOWED_TAGS));
        }
        this.readingInventory = true;
        StackUtils.readItems((IInventory)this.matrix, 0, tag);
        StackUtils.readItems(this.patterns, 1, tag);
        StackUtils.readItems(this.filter, 2, tag);
        StackUtils.readItems(this.processingMatrix, 3, tag);
        if (tag.func_74764_b(NBT_PROCESSING_MATRIX_FLUIDS)) {
            this.processingMatrixFluids.readFromNbt(tag.func_74775_l(NBT_PROCESSING_MATRIX_FLUIDS));
        }
        if (tag.func_74764_b(NBT_TAB_SELECTED)) {
            this.tabSelected = tag.func_74762_e(NBT_TAB_SELECTED);
        }
        if (tag.func_74764_b(NBT_TAB_PAGE)) {
            this.tabPage = tag.func_74762_e(NBT_TAB_PAGE);
        }
        this.readingInventory = false;
    }

    @Override
    public ResourceLocation getId() {
        return GridNetworkNode.getId(this.type);
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        tag.func_218657_a(NBT_ALLOWED_TAGS, (INBT)this.allowedTagList.writeToNbt());
        StackUtils.writeItems((IInventory)this.matrix, 0, tag);
        StackUtils.writeItems((IItemHandler)this.patterns, 1, tag);
        StackUtils.writeItems((IItemHandler)this.filter, 2, tag);
        StackUtils.writeItems((IItemHandler)this.processingMatrix, 3, tag);
        tag.func_218657_a(NBT_PROCESSING_MATRIX_FLUIDS, (INBT)this.processingMatrixFluids.writeToNbt());
        tag.func_74768_a(NBT_TAB_SELECTED, this.tabSelected);
        tag.func_74768_a(NBT_TAB_PAGE, this.tabPage);
        return tag;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_VIEW_TYPE, this.viewType);
        tag.func_74768_a(NBT_SORTING_DIRECTION, this.sortingDirection);
        tag.func_74768_a(NBT_SORTING_TYPE, this.sortingType);
        tag.func_74768_a(NBT_SEARCH_BOX_MODE, this.searchBoxMode);
        tag.func_74768_a(NBT_SIZE, this.size);
        tag.func_74757_a(NBT_EXACT_MODE, this.exactPattern);
        tag.func_74757_a(NBT_PROCESSING_PATTERN, this.processingPattern);
        tag.func_74768_a(NBT_PROCESSING_TYPE, this.processingType);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_VIEW_TYPE)) {
            this.viewType = tag.func_74762_e(NBT_VIEW_TYPE);
        }
        if (tag.func_74764_b(NBT_SORTING_DIRECTION)) {
            this.sortingDirection = tag.func_74762_e(NBT_SORTING_DIRECTION);
        }
        if (tag.func_74764_b(NBT_SORTING_TYPE)) {
            this.sortingType = tag.func_74762_e(NBT_SORTING_TYPE);
        }
        if (tag.func_74764_b(NBT_SEARCH_BOX_MODE)) {
            this.searchBoxMode = tag.func_74762_e(NBT_SEARCH_BOX_MODE);
        }
        if (tag.func_74764_b(NBT_SIZE)) {
            this.size = tag.func_74762_e(NBT_SIZE);
        }
        if (tag.func_74764_b(NBT_EXACT_MODE)) {
            this.exactPattern = tag.func_74767_n(NBT_EXACT_MODE);
        }
        if (tag.func_74764_b(NBT_PROCESSING_PATTERN)) {
            this.processingPattern = tag.func_74767_n(NBT_PROCESSING_PATTERN);
        }
        if (tag.func_74764_b(NBT_PROCESSING_TYPE)) {
            this.processingType = tag.func_74762_e(NBT_PROCESSING_TYPE);
        }
    }

    @Override
    public IItemHandler getDrops() {
        switch (this.type) {
            case CRAFTING: {
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter, new InvWrapper((IInventory)this.matrix)});
            }
            case PATTERN: {
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter, this.patterns});
            }
        }
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.filter});
    }
}

