/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private final ForgeConfigSpec spec;
    private final Upgrades upgrades = new Upgrades();
    private final Controller controller = new Controller();
    private final Cable cable = new Cable();
    private final Grid grid = new Grid();
    private final DiskDrive diskDrive = new DiskDrive();
    private final StorageBlock storageBlock = new StorageBlock();
    private final FluidStorageBlock fluidStorageBlock = new FluidStorageBlock();
    private final ExternalStorage externalStorage = new ExternalStorage();
    private final Importer importer = new Importer();
    private final Exporter exporter = new Exporter();
    private final NetworkReceiver networkReceiver = new NetworkReceiver();
    private final NetworkTransmitter networkTransmitter = new NetworkTransmitter();
    private final Relay relay = new Relay();
    private final Detector detector = new Detector();
    private final SecurityManager securityManager = new SecurityManager();
    private final Interface iface = new Interface();
    private final FluidInterface fluidInterface = new FluidInterface();
    private final WirelessTransmitter wirelessTransmitter = new WirelessTransmitter();
    private final StorageMonitor storageMonitor = new StorageMonitor();
    private final WirelessGrid wirelessGrid = new WirelessGrid();
    private final WirelessFluidGrid wirelessFluidGrid = new WirelessFluidGrid();
    private final Constructor constructor = new Constructor();
    private final Destructor destructor = new Destructor();
    private final DiskManipulator diskManipulator = new DiskManipulator();
    private final PortableGrid portableGrid = new PortableGrid();
    private final Crafter crafter = new Crafter();
    private final CrafterManager crafterManager = new CrafterManager();
    private final CraftingMonitor craftingMonitor = new CraftingMonitor();
    private final WirelessCraftingMonitor wirelessCraftingMonitor = new WirelessCraftingMonitor();
    private final Autocrafting autocrafting = new Autocrafting();

    public ServerConfig() {
        this.spec = this.builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public Upgrades getUpgrades() {
        return this.upgrades;
    }

    public Controller getController() {
        return this.controller;
    }

    public Cable getCable() {
        return this.cable;
    }

    public DiskDrive getDiskDrive() {
        return this.diskDrive;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public StorageBlock getStorageBlock() {
        return this.storageBlock;
    }

    public FluidStorageBlock getFluidStorageBlock() {
        return this.fluidStorageBlock;
    }

    public ExternalStorage getExternalStorage() {
        return this.externalStorage;
    }

    public Importer getImporter() {
        return this.importer;
    }

    public Exporter getExporter() {
        return this.exporter;
    }

    public NetworkReceiver getNetworkReceiver() {
        return this.networkReceiver;
    }

    public NetworkTransmitter getNetworkTransmitter() {
        return this.networkTransmitter;
    }

    public Relay getRelay() {
        return this.relay;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public Interface getInterface() {
        return this.iface;
    }

    public FluidInterface getFluidInterface() {
        return this.fluidInterface;
    }

    public WirelessTransmitter getWirelessTransmitter() {
        return this.wirelessTransmitter;
    }

    public StorageMonitor getStorageMonitor() {
        return this.storageMonitor;
    }

    public WirelessGrid getWirelessGrid() {
        return this.wirelessGrid;
    }

    public WirelessFluidGrid getWirelessFluidGrid() {
        return this.wirelessFluidGrid;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public Destructor getDestructor() {
        return this.destructor;
    }

    public DiskManipulator getDiskManipulator() {
        return this.diskManipulator;
    }

    public PortableGrid getPortableGrid() {
        return this.portableGrid;
    }

    public Crafter getCrafter() {
        return this.crafter;
    }

    public CrafterManager getCrafterManager() {
        return this.crafterManager;
    }

    public CraftingMonitor getCraftingMonitor() {
        return this.craftingMonitor;
    }

    public WirelessCraftingMonitor getWirelessCraftingMonitor() {
        return this.wirelessCraftingMonitor;
    }

    public Autocrafting getAutocrafting() {
        return this.autocrafting;
    }

    public class Autocrafting {
        private final ForgeConfigSpec.IntValue calculationTimeoutMs;

        public Autocrafting() {
            ServerConfig.this.builder.push("autocrafting");
            this.calculationTimeoutMs = ServerConfig.this.builder.comment("The autocrafting calculation timeout in milliseconds, crafting tasks taking longer than this to calculate are cancelled to avoid server strain").defineInRange("calculationTimeoutMs", 5000, 5000, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getCalculationTimeoutMs() {
            return (Integer)this.calculationTimeoutMs.get();
        }
    }

    public class WirelessCraftingMonitor {
        private final ForgeConfigSpec.BooleanValue useEnergy;
        private final ForgeConfigSpec.IntValue capacity;
        private final ForgeConfigSpec.IntValue openUsage;
        private final ForgeConfigSpec.IntValue cancelUsage;
        private final ForgeConfigSpec.IntValue cancelAllUsage;

        public WirelessCraftingMonitor() {
            ServerConfig.this.builder.push("wirelessCraftingMonitor");
            this.useEnergy = ServerConfig.this.builder.comment("Whether the Wireless Crafting Monitor uses energy").define("useEnergy", true);
            this.capacity = ServerConfig.this.builder.comment("The energy capacity of the Wireless Crafting Monitor").defineInRange("capacity", 3200, 0, Integer.MAX_VALUE);
            this.openUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Crafting Monitor to open").defineInRange("openUsage", 30, 0, Integer.MAX_VALUE);
            this.cancelUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Crafting Monitor to cancel a crafting task").defineInRange("cancelUsage", 5, 0, Integer.MAX_VALUE);
            this.cancelAllUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Crafting Monitor to cancel all crafting tasks").defineInRange("cancelAllUsage", 10, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public boolean getUseEnergy() {
            return (Boolean)this.useEnergy.get();
        }

        public int getCapacity() {
            return (Integer)this.capacity.get();
        }

        public int getOpenUsage() {
            return (Integer)this.openUsage.get();
        }

        public int getCancelUsage() {
            return (Integer)this.cancelUsage.get();
        }

        public int getCancelAllUsage() {
            return (Integer)this.cancelAllUsage.get();
        }
    }

    public class CraftingMonitor {
        private final ForgeConfigSpec.IntValue usage;

        public CraftingMonitor() {
            ServerConfig.this.builder.push("craftingMonitor");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Crafting Monitor").defineInRange("usage", 8, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class CrafterManager {
        private final ForgeConfigSpec.IntValue usage;

        public CrafterManager() {
            ServerConfig.this.builder.push("crafterManager");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Crafter Manager").defineInRange("usage", 8, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class Crafter {
        private final ForgeConfigSpec.IntValue usage;
        private final ForgeConfigSpec.IntValue patternUsage;

        public Crafter() {
            ServerConfig.this.builder.push("crafter");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Crafter").defineInRange("usage", 4, 0, Integer.MAX_VALUE);
            this.patternUsage = ServerConfig.this.builder.comment("The energy used for every Pattern in the Crafter").defineInRange("patternUsage", 1, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }

        public int getPatternUsage() {
            return (Integer)this.patternUsage.get();
        }
    }

    public class DiskManipulator {
        private final ForgeConfigSpec.IntValue usage;

        public DiskManipulator() {
            ServerConfig.this.builder.push("diskManipulator");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Disk Manipulator").defineInRange("usage", 4, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class Destructor {
        private final ForgeConfigSpec.IntValue usage;

        public Destructor() {
            ServerConfig.this.builder.push("destructor");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Destructor").defineInRange("usage", 3, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class Constructor {
        private final ForgeConfigSpec.IntValue usage;

        public Constructor() {
            ServerConfig.this.builder.push("constructor");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Constructor").defineInRange("usage", 3, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class PortableGrid {
        private final ForgeConfigSpec.BooleanValue useEnergy;
        private final ForgeConfigSpec.IntValue capacity;
        private final ForgeConfigSpec.IntValue openUsage;
        private final ForgeConfigSpec.IntValue extractUsage;
        private final ForgeConfigSpec.IntValue insertUsage;

        public PortableGrid() {
            ServerConfig.this.builder.push("portableGrid");
            this.useEnergy = ServerConfig.this.builder.comment("Whether the Portable Grid uses energy").define("useEnergy", true);
            this.capacity = ServerConfig.this.builder.comment("The energy capacity of the Portable Grid").defineInRange("capacity", 3200, 0, Integer.MAX_VALUE);
            this.openUsage = ServerConfig.this.builder.comment("The energy used by the Portable Grid to open").defineInRange("openUsage", 30, 0, Integer.MAX_VALUE);
            this.extractUsage = ServerConfig.this.builder.comment("The energy used by the Portable Grid to extract items or fluids").defineInRange("extractUsage", 5, 0, Integer.MAX_VALUE);
            this.insertUsage = ServerConfig.this.builder.comment("The energy used by the Portable Grid to insert items or fluids").defineInRange("insertUsage", 5, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public boolean getUseEnergy() {
            return (Boolean)this.useEnergy.get();
        }

        public int getCapacity() {
            return (Integer)this.capacity.get();
        }

        public int getOpenUsage() {
            return (Integer)this.openUsage.get();
        }

        public int getExtractUsage() {
            return (Integer)this.extractUsage.get();
        }

        public int getInsertUsage() {
            return (Integer)this.insertUsage.get();
        }
    }

    public class WirelessFluidGrid {
        private final ForgeConfigSpec.BooleanValue useEnergy;
        private final ForgeConfigSpec.IntValue capacity;
        private final ForgeConfigSpec.IntValue openUsage;
        private final ForgeConfigSpec.IntValue extractUsage;
        private final ForgeConfigSpec.IntValue insertUsage;

        public WirelessFluidGrid() {
            ServerConfig.this.builder.push("wirelessFluidGrid");
            this.useEnergy = ServerConfig.this.builder.comment("Whether the Wireless Fluid Grid uses energy").define("useEnergy", true);
            this.capacity = ServerConfig.this.builder.comment("The energy capacity of the Wireless Fluid Grid").defineInRange("capacity", 3200, 0, Integer.MAX_VALUE);
            this.openUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Fluid Grid to open").defineInRange("openUsage", 30, 0, Integer.MAX_VALUE);
            this.extractUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Fluid Grid to extract fluids").defineInRange("extractUsage", 5, 0, Integer.MAX_VALUE);
            this.insertUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Fluid Grid to insert fluids").defineInRange("insertUsage", 5, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public boolean getUseEnergy() {
            return (Boolean)this.useEnergy.get();
        }

        public int getCapacity() {
            return (Integer)this.capacity.get();
        }

        public int getOpenUsage() {
            return (Integer)this.openUsage.get();
        }

        public int getExtractUsage() {
            return (Integer)this.extractUsage.get();
        }

        public int getInsertUsage() {
            return (Integer)this.insertUsage.get();
        }
    }

    public class WirelessGrid {
        private final ForgeConfigSpec.BooleanValue useEnergy;
        private final ForgeConfigSpec.IntValue capacity;
        private final ForgeConfigSpec.IntValue openUsage;
        private final ForgeConfigSpec.IntValue extractUsage;
        private final ForgeConfigSpec.IntValue insertUsage;

        public WirelessGrid() {
            ServerConfig.this.builder.push("wirelessGrid");
            this.useEnergy = ServerConfig.this.builder.comment("Whether the Wireless Grid uses energy").define("useEnergy", true);
            this.capacity = ServerConfig.this.builder.comment("The energy capacity of the Wireless Grid").defineInRange("capacity", 3200, 0, Integer.MAX_VALUE);
            this.openUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Grid to open").defineInRange("openUsage", 30, 0, Integer.MAX_VALUE);
            this.extractUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Grid to extract items").defineInRange("extractUsage", 5, 0, Integer.MAX_VALUE);
            this.insertUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Grid to insert items").defineInRange("insertUsage", 5, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public boolean getUseEnergy() {
            return (Boolean)this.useEnergy.get();
        }

        public int getCapacity() {
            return (Integer)this.capacity.get();
        }

        public int getOpenUsage() {
            return (Integer)this.openUsage.get();
        }

        public int getExtractUsage() {
            return (Integer)this.extractUsage.get();
        }

        public int getInsertUsage() {
            return (Integer)this.insertUsage.get();
        }
    }

    public class StorageMonitor {
        private final ForgeConfigSpec.IntValue usage;

        public StorageMonitor() {
            ServerConfig.this.builder.push("storageMonitor");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Storage Monitor").defineInRange("usage", 3, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class WirelessTransmitter {
        private final ForgeConfigSpec.IntValue usage;
        private final ForgeConfigSpec.IntValue baseRange;
        private final ForgeConfigSpec.IntValue rangePerUpgrade;

        public WirelessTransmitter() {
            ServerConfig.this.builder.push("wirelessTransmitter");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Wireless Transmitter").defineInRange("usage", 8, 0, Integer.MAX_VALUE);
            this.baseRange = ServerConfig.this.builder.comment("The base range of the Wireless Transmitter").defineInRange("baseRange", 16, 0, Integer.MAX_VALUE);
            this.rangePerUpgrade = ServerConfig.this.builder.comment("The additional range per Range Upgrade in the Wireless Transmitter").defineInRange("rangePerUpgrade", 8, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }

        public int getBaseRange() {
            return (Integer)this.baseRange.get();
        }

        public int getRangePerUpgrade() {
            return (Integer)this.rangePerUpgrade.get();
        }
    }

    public class FluidInterface {
        private final ForgeConfigSpec.IntValue usage;

        public FluidInterface() {
            ServerConfig.this.builder.push("fluidInterface");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Fluid Interface").defineInRange("usage", 2, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class Interface {
        private final ForgeConfigSpec.IntValue usage;

        public Interface() {
            ServerConfig.this.builder.push("interface");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Interface").defineInRange("usage", 2, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class SecurityManager {
        private final ForgeConfigSpec.IntValue usage;
        private final ForgeConfigSpec.IntValue usagePerCard;

        public SecurityManager() {
            ServerConfig.this.builder.push("securityManager");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Security Manager").defineInRange("usage", 4, 0, Integer.MAX_VALUE);
            this.usagePerCard = ServerConfig.this.builder.comment("The additional energy used by Security Cards in the Security Manager").defineInRange("usagePerCard", 10, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }

        public int getUsagePerCard() {
            return (Integer)this.usagePerCard.get();
        }
    }

    public class Detector {
        private final ForgeConfigSpec.IntValue usage;

        public Detector() {
            ServerConfig.this.builder.push("detector");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Detector").defineInRange("usage", 2, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class Relay {
        private final ForgeConfigSpec.IntValue usage;

        public Relay() {
            ServerConfig.this.builder.push("relay");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Relay").defineInRange("usage", 1, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class NetworkTransmitter {
        private final ForgeConfigSpec.IntValue usage;

        public NetworkTransmitter() {
            ServerConfig.this.builder.push("networkTransmitter");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Network Transmitter").defineInRange("usage", 64, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class NetworkReceiver {
        private final ForgeConfigSpec.IntValue usage;

        public NetworkReceiver() {
            ServerConfig.this.builder.push("networkReceiver");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Network Receiver").defineInRange("usage", 0, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class Exporter {
        private final ForgeConfigSpec.IntValue usage;

        public Exporter() {
            ServerConfig.this.builder.push("exporter");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Exporter").defineInRange("usage", 1, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class Importer {
        private final ForgeConfigSpec.IntValue usage;

        public Importer() {
            ServerConfig.this.builder.push("importer");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Importer").defineInRange("usage", 1, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class ExternalStorage {
        private final ForgeConfigSpec.IntValue usage;

        public ExternalStorage() {
            ServerConfig.this.builder.push("externalStorage");
            this.usage = ServerConfig.this.builder.comment("The energy used by the External Storage").defineInRange("usage", 6, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class FluidStorageBlock {
        private final ForgeConfigSpec.IntValue sixtyFourKUsage;
        private final ForgeConfigSpec.IntValue twoHundredFiftySixKUsage;
        private final ForgeConfigSpec.IntValue thousandTwentyFourKUsage;
        private final ForgeConfigSpec.IntValue fourThousandNinetySixKUsage;
        private final ForgeConfigSpec.IntValue creativeUsage;

        public FluidStorageBlock() {
            ServerConfig.this.builder.push("fluidStorageBlock");
            this.sixtyFourKUsage = ServerConfig.this.builder.comment("The energy used by the 64k Fluid Storage Block").defineInRange("sixtyFourKUsage", 2, 0, Integer.MAX_VALUE);
            this.twoHundredFiftySixKUsage = ServerConfig.this.builder.comment("The energy used by the 256k Fluid Storage Block").defineInRange("twoHundredFiftySixKUsage", 4, 0, Integer.MAX_VALUE);
            this.thousandTwentyFourKUsage = ServerConfig.this.builder.comment("The energy used by the 1024k Fluid Storage Block").defineInRange("thousandTwentyFourKUsage", 6, 0, Integer.MAX_VALUE);
            this.fourThousandNinetySixKUsage = ServerConfig.this.builder.comment("The energy used by the 4096k Fluid Storage Block").defineInRange("fourThousandNinetySixKUsage", 8, 0, Integer.MAX_VALUE);
            this.creativeUsage = ServerConfig.this.builder.comment("The energy used by the Creative Fluid Storage Block").defineInRange("creativeUsage", 10, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getSixtyFourKUsage() {
            return (Integer)this.sixtyFourKUsage.get();
        }

        public int getTwoHundredFiftySixKUsage() {
            return (Integer)this.twoHundredFiftySixKUsage.get();
        }

        public int getThousandTwentyFourKUsage() {
            return (Integer)this.thousandTwentyFourKUsage.get();
        }

        public int getFourThousandNinetySixKUsage() {
            return (Integer)this.fourThousandNinetySixKUsage.get();
        }

        public int getCreativeUsage() {
            return (Integer)this.creativeUsage.get();
        }
    }

    public class StorageBlock {
        private final ForgeConfigSpec.IntValue oneKUsage;
        private final ForgeConfigSpec.IntValue fourKUsage;
        private final ForgeConfigSpec.IntValue sixteenKUsage;
        private final ForgeConfigSpec.IntValue sixtyFourKUsage;
        private final ForgeConfigSpec.IntValue creativeUsage;

        public StorageBlock() {
            ServerConfig.this.builder.push("storageBlock");
            this.oneKUsage = ServerConfig.this.builder.comment("The energy used by the 1k Storage Block").defineInRange("oneKUsage", 2, 0, Integer.MAX_VALUE);
            this.fourKUsage = ServerConfig.this.builder.comment("The energy used by the 4k Storage Block").defineInRange("fourKUsage", 4, 0, Integer.MAX_VALUE);
            this.sixteenKUsage = ServerConfig.this.builder.comment("The energy used by the 16k Storage Block").defineInRange("sixteenKUsage", 6, 0, Integer.MAX_VALUE);
            this.sixtyFourKUsage = ServerConfig.this.builder.comment("The energy used by the 64k Storage Block").defineInRange("sixtyFourKUsage", 8, 0, Integer.MAX_VALUE);
            this.creativeUsage = ServerConfig.this.builder.comment("The energy used by the Creative Storage Block").defineInRange("creativeUsage", 10, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getOneKUsage() {
            return (Integer)this.oneKUsage.get();
        }

        public int getFourKUsage() {
            return (Integer)this.fourKUsage.get();
        }

        public int getSixteenKUsage() {
            return (Integer)this.sixteenKUsage.get();
        }

        public int getSixtyFourKUsage() {
            return (Integer)this.sixtyFourKUsage.get();
        }

        public int getCreativeUsage() {
            return (Integer)this.creativeUsage.get();
        }
    }

    public class Upgrades {
        private final ForgeConfigSpec.IntValue rangeUpgradeUsage;
        private final ForgeConfigSpec.IntValue speedUpgradeUsage;
        private final ForgeConfigSpec.IntValue craftingUpgradeUsage;
        private final ForgeConfigSpec.IntValue stackUpgradeUsage;
        private final ForgeConfigSpec.IntValue silkTouchUpgradeUsage;
        private final ForgeConfigSpec.IntValue fortune1UpgradeUsage;
        private final ForgeConfigSpec.IntValue fortune2UpgradeUsage;
        private final ForgeConfigSpec.IntValue fortune3UpgradeUsage;
        private final ForgeConfigSpec.IntValue regulatorUpgradeUsage;

        public Upgrades() {
            ServerConfig.this.builder.push("upgrades");
            this.rangeUpgradeUsage = ServerConfig.this.builder.comment("The additional energy used by the Range Upgrade").defineInRange("rangeUpgradeUsage", 8, 0, Integer.MAX_VALUE);
            this.speedUpgradeUsage = ServerConfig.this.builder.comment("The additional energy used by the Speed Upgrade").defineInRange("speedUpgradeUsage", 2, 0, Integer.MAX_VALUE);
            this.craftingUpgradeUsage = ServerConfig.this.builder.comment("The additional energy used by the Crafting Upgrade").defineInRange("craftingUpgradeUsage", 5, 0, Integer.MAX_VALUE);
            this.stackUpgradeUsage = ServerConfig.this.builder.comment("The additional energy used by the Stack Upgrade").defineInRange("stackUpgradeUsage", 12, 0, Integer.MAX_VALUE);
            this.silkTouchUpgradeUsage = ServerConfig.this.builder.comment("The additional energy used by the Silk Touch Upgrade").defineInRange("silkTouchUpgradeUsage", 15, 0, Integer.MAX_VALUE);
            this.fortune1UpgradeUsage = ServerConfig.this.builder.comment("The additional energy used by the Fortune 1 Upgrade").defineInRange("fortune1UpgradeUsage", 10, 0, Integer.MAX_VALUE);
            this.fortune2UpgradeUsage = ServerConfig.this.builder.comment("The additional energy used by the Fortune 2 Upgrade").defineInRange("fortune2UpgradeUsage", 12, 0, Integer.MAX_VALUE);
            this.fortune3UpgradeUsage = ServerConfig.this.builder.comment("The additional energy used by the Fortune 3 Upgrade").defineInRange("fortune3UpgradeUsage", 14, 0, Integer.MAX_VALUE);
            this.regulatorUpgradeUsage = ServerConfig.this.builder.comment("The additional energy used by the Regulator Upgrade").defineInRange("regulatorUpgradeUsage", 15, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getRangeUpgradeUsage() {
            return (Integer)this.rangeUpgradeUsage.get();
        }

        public int getSpeedUpgradeUsage() {
            return (Integer)this.speedUpgradeUsage.get();
        }

        public int getCraftingUpgradeUsage() {
            return (Integer)this.craftingUpgradeUsage.get();
        }

        public int getStackUpgradeUsage() {
            return (Integer)this.stackUpgradeUsage.get();
        }

        public int getSilkTouchUpgradeUsage() {
            return (Integer)this.silkTouchUpgradeUsage.get();
        }

        public int getFortune1UpgradeUsage() {
            return (Integer)this.fortune1UpgradeUsage.get();
        }

        public int getFortune2UpgradeUsage() {
            return (Integer)this.fortune2UpgradeUsage.get();
        }

        public int getFortune3UpgradeUsage() {
            return (Integer)this.fortune3UpgradeUsage.get();
        }

        public int getRegulatorUpgradeUsage() {
            return (Integer)this.regulatorUpgradeUsage.get();
        }
    }

    public class Grid {
        private final ForgeConfigSpec.IntValue gridUsage;
        private final ForgeConfigSpec.IntValue craftingGridUsage;
        private final ForgeConfigSpec.IntValue patternGridUsage;
        private final ForgeConfigSpec.IntValue fluidGridUsage;

        public Grid() {
            ServerConfig.this.builder.push("grid");
            this.gridUsage = ServerConfig.this.builder.comment("The energy used by Grids").defineInRange("gridUsage", 2, 0, Integer.MAX_VALUE);
            this.craftingGridUsage = ServerConfig.this.builder.comment("The energy used by Crafting Grids").defineInRange("craftingGridUsage", 4, 0, Integer.MAX_VALUE);
            this.patternGridUsage = ServerConfig.this.builder.comment("The energy used by Pattern Grids").defineInRange("patternGridUsage", 4, 0, Integer.MAX_VALUE);
            this.fluidGridUsage = ServerConfig.this.builder.comment("The energy used by Fluid Grids").defineInRange("fluidGridUsage", 2, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getGridUsage() {
            return (Integer)this.gridUsage.get();
        }

        public int getCraftingGridUsage() {
            return (Integer)this.craftingGridUsage.get();
        }

        public int getPatternGridUsage() {
            return (Integer)this.patternGridUsage.get();
        }

        public int getFluidGridUsage() {
            return (Integer)this.fluidGridUsage.get();
        }
    }

    public class DiskDrive {
        private final ForgeConfigSpec.IntValue usage;
        private final ForgeConfigSpec.IntValue diskUsage;

        public DiskDrive() {
            ServerConfig.this.builder.push("diskDrive");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Disk Drive").defineInRange("usage", 0, 0, Integer.MAX_VALUE);
            this.diskUsage = ServerConfig.this.builder.comment("The energy used per disk in the Disk Drive").defineInRange("diskUsage", 1, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }

        public int getDiskUsage() {
            return (Integer)this.diskUsage.get();
        }
    }

    public class Cable {
        private final ForgeConfigSpec.IntValue usage;

        public Cable() {
            ServerConfig.this.builder.push("cable");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Cable").defineInRange("usage", 0, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class Controller {
        private final ForgeConfigSpec.BooleanValue useEnergy;
        private final ForgeConfigSpec.IntValue capacity;
        private final ForgeConfigSpec.IntValue baseUsage;
        private final ForgeConfigSpec.IntValue maxTransfer;

        public Controller() {
            ServerConfig.this.builder.push("controller");
            this.useEnergy = ServerConfig.this.builder.comment("Whether the Controller uses energy").define("useEnergy", true);
            this.capacity = ServerConfig.this.builder.comment("The energy capacity of the Controller").defineInRange("capacity", 32000, 0, Integer.MAX_VALUE);
            this.baseUsage = ServerConfig.this.builder.comment("The base energy used by the Controller").defineInRange("baseUsage", 0, 0, Integer.MAX_VALUE);
            this.maxTransfer = ServerConfig.this.builder.comment("The maximum energy that the Controller can receive").defineInRange("maxTransfer", Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public boolean getUseEnergy() {
            return (Boolean)this.useEnergy.get();
        }

        public int getCapacity() {
            return (Integer)this.capacity.get();
        }

        public int getBaseUsage() {
            return (Integer)this.baseUsage.get();
        }

        public int getMaxTransfer() {
            return (Integer)this.maxTransfer.get();
        }
    }
}

