/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container;

import com.refinedmods.refinedstorage.RSContainers;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.container.BaseContainer;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.container.slot.grid.CraftingGridSlot;
import com.refinedmods.refinedstorage.container.slot.grid.ResultCraftingGridSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyBaseSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyDisabledSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyFilterSlot;
import com.refinedmods.refinedstorage.screen.IScreenInfoProvider;
import com.refinedmods.refinedstorage.tile.BaseTile;
import com.refinedmods.refinedstorage.tile.grid.portable.IPortableGrid;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class GridContainer
extends BaseContainer
implements ICraftingGridListener {
    private final IGrid grid;
    private IStorageCache storageCache;
    private IStorageCacheListener storageCacheListener;
    private IScreenInfoProvider screenInfoProvider;
    private ResultCraftingGridSlot craftingResultSlot;
    private LegacyBaseSlot patternResultSlot;

    public GridContainer(IGrid grid, @Nullable BaseTile gridTile, PlayerEntity player, int windowId) {
        super(RSContainers.GRID, gridTile, player, windowId);
        this.grid = grid;
        grid.addCraftingListener(this);
    }

    public IScreenInfoProvider getScreenInfoProvider() {
        return this.screenInfoProvider;
    }

    public void setScreenInfoProvider(IScreenInfoProvider screenInfoProvider) {
        this.screenInfoProvider = screenInfoProvider;
    }

    public void initSlots() {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.transferManager.clearTransfers();
        this.addFilterSlots();
        if (this.grid instanceof IPortableGrid) {
            this.addPortableGridSlots();
        }
        if (this.grid.getGridType() == GridType.CRAFTING) {
            this.addCraftingSlots();
        } else if (this.grid.getGridType() == GridType.PATTERN) {
            this.addPatternSlots();
        }
        this.transferManager.setNotFoundHandler(slotIndex -> {
            if (!this.getPlayer().func_130014_f_().field_72995_K) {
                Slot slot = (Slot)this.field_75151_b.get((int)slotIndex);
                if (this.grid instanceof IPortableGrid && slot instanceof SlotItemHandler && ((SlotItemHandler)slot).getItemHandler().equals((Object)((IPortableGrid)((Object)this.grid)).getDiskInventory())) {
                    return ItemStack.field_190927_a;
                }
                if (slot.func_75216_d()) {
                    if (slot == this.craftingResultSlot) {
                        this.grid.onCraftedShift(this.getPlayer());
                        this.func_75142_b();
                    } else {
                        ItemStack stack = slot.func_75211_c();
                        if (this.grid.getGridType() == GridType.FLUID) {
                            IFluidGridHandler fluidHandler = this.grid.getFluidHandler();
                            if (fluidHandler != null) {
                                slot.func_75215_d(fluidHandler.onInsert((ServerPlayerEntity)this.getPlayer(), stack));
                            }
                        } else {
                            IItemGridHandler itemHandler = this.grid.getItemHandler();
                            if (itemHandler != null) {
                                slot.func_75215_d(itemHandler.onInsert((ServerPlayerEntity)this.getPlayer(), stack, false));
                            } else if (slot instanceof CraftingGridSlot && this.func_75135_a(stack, 14, 50, false)) {
                                slot.func_75218_e();
                                this.grid.onCraftingMatrixChanged();
                            }
                        }
                        this.func_75142_b();
                    }
                }
            }
            return ItemStack.field_190927_a;
        });
        this.addPlayerInventory(8, this.screenInfoProvider.getYPlayerInventory());
    }

    private void addPortableGridSlots() {
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)((IPortableGrid)((Object)this.grid)).getDiskInventory(), 0, 204, 6));
        this.transferManager.addBiTransfer((IInventory)this.getPlayer().field_71071_by, (IItemHandler)((IPortableGrid)((Object)this.grid)).getDiskInventory());
    }

    private void addFilterSlots() {
        int yStart = 6;
        if (this.grid instanceof IPortableGrid) {
            yStart = 38;
        }
        for (int i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.grid.getFilter(), i, 204, yStart + 18 * i));
        }
        this.transferManager.addBiTransfer((IInventory)this.getPlayer().field_71071_by, (IItemHandler)this.grid.getFilter());
    }

    private void addCraftingSlots() {
        int headerAndSlots = this.screenInfoProvider.getTopHeight() + this.screenInfoProvider.getVisibleRows() * 18;
        int x = 26;
        int y = headerAndSlots + 4;
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new CraftingGridSlot((IInventory)this.grid.getCraftingMatrix(), i, x, y));
            x += 18;
            if ((i + 1) % 3 != 0) continue;
            y += 18;
            x = 26;
        }
        this.craftingResultSlot = new ResultCraftingGridSlot(this.getPlayer(), this.grid, 0, 134, headerAndSlots + 22);
        this.func_75146_a((Slot)this.craftingResultSlot);
    }

    private void addPatternSlots() {
        int i;
        int ox;
        int headerAndSlots = this.screenInfoProvider.getTopHeight() + this.screenInfoProvider.getVisibleRows() * 18;
        this.func_75146_a((Slot)new SlotItemHandler(((GridNetworkNode)this.grid).getPatterns(), 0, 172, headerAndSlots + 4));
        this.func_75146_a((Slot)new SlotItemHandler(((GridNetworkNode)this.grid).getPatterns(), 1, 172, headerAndSlots + 40));
        this.transferManager.addBiTransfer((IInventory)this.getPlayer().field_71071_by, ((GridNetworkNode)this.grid).getPatterns());
        int x = ox = 8;
        int y = headerAndSlots + 4;
        for (i = 0; i < 18; ++i) {
            int itemFilterSlotConfig = 1;
            if (i < 9) {
                itemFilterSlotConfig |= 4;
            }
            int fluidFilterSlotConfig = 1;
            if (i < 9) {
                fluidFilterSlotConfig |= 2;
            }
            this.func_75146_a((Slot)new FilterSlot((IItemHandler)((GridNetworkNode)this.grid).getProcessingMatrix(), i, x, y, itemFilterSlotConfig).setEnableHandler(() -> ((GridNetworkNode)this.grid).isProcessingPattern() && ((GridNetworkNode)this.grid).getType() == 0));
            this.func_75146_a((Slot)new FluidFilterSlot(((GridNetworkNode)this.grid).getProcessingMatrixFluids(), i, x, y, fluidFilterSlotConfig).setEnableHandler(() -> ((GridNetworkNode)this.grid).isProcessingPattern() && ((GridNetworkNode)this.grid).getType() == 1));
            x += 18;
            if ((i + 1) % 3 != 0) continue;
            if (i == 8) {
                x = ox = 98;
                y = headerAndSlots + 4;
                continue;
            }
            x = ox;
            y += 18;
        }
        x = 26;
        y = headerAndSlots + 4;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new LegacyFilterSlot((IInventory)this.grid.getCraftingMatrix(), i, x, y).setEnableHandler(() -> !((GridNetworkNode)this.grid).isProcessingPattern()));
            x += 18;
            if ((i + 1) % 3 != 0) continue;
            y += 18;
            x = 26;
        }
        this.patternResultSlot = new LegacyDisabledSlot((IInventory)this.grid.getCraftingResult(), 0, 134, headerAndSlots + 22).setEnableHandler(() -> !((GridNetworkNode)this.grid).isProcessingPattern());
        this.func_75146_a(this.patternResultSlot);
    }

    public IGrid getGrid() {
        return this.grid;
    }

    @Override
    public void onCraftingMatrixChanged() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof CraftingGridSlot) && slot != this.craftingResultSlot && slot != this.patternResultSlot) continue;
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof ServerPlayerEntity)) continue;
                ((ServerPlayerEntity)listener).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, i, slot.func_75211_c()));
            }
        }
    }

    @Override
    public void func_75142_b() {
        if (!this.getPlayer().field_70170_p.field_72995_K) {
            if (this.grid.getStorageCache() == null) {
                if (this.storageCacheListener != null) {
                    this.storageCache.removeListener(this.storageCacheListener);
                    this.storageCacheListener = null;
                    this.storageCache = null;
                }
            } else if (this.storageCacheListener == null) {
                this.storageCacheListener = this.grid.createListener((ServerPlayerEntity)this.getPlayer());
                this.storageCache = this.grid.getStorageCache();
                this.storageCache.addListener(this.storageCacheListener);
            }
        }
        super.func_75142_b();
    }

    @Override
    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (!player.func_130014_f_().field_72995_K) {
            this.grid.onClosed(player);
            if (this.storageCache != null && this.storageCacheListener != null) {
                this.storageCache.removeListener(this.storageCacheListener);
            }
        }
        this.grid.removeCraftingListener(this);
    }

    @Override
    public boolean func_94530_a(ItemStack stack, Slot slot) {
        if (slot == this.craftingResultSlot || slot == this.patternResultSlot) {
            return false;
        }
        return super.func_94530_a(stack, slot);
    }

    @Override
    protected int getDisabledSlotNumber() {
        return this.grid.getSlotId();
    }
}

