/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.craftingtweaks;

import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.container.GridContainer;
import com.refinedmods.refinedstorage.container.slot.grid.CraftingGridSlot;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;

public final class CraftingTweaksIntegration {
    private static final String ID = "craftingtweaks";

    private CraftingTweaksIntegration() {
    }

    public static boolean isLoaded() {
        return ModList.get().isLoaded(ID);
    }

    public static boolean isCraftingTweaksClass(Class<?> clazz) {
        return clazz.getName().startsWith("net.blay09.mods.craftingtweaks");
    }

    public static void register() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("ContainerClass", GridContainer.class.getName());
        tag.func_74778_a("ValidContainerPredicate", ValidContainerPredicate.class.getName());
        tag.func_74778_a("GetGridStartFunction", GetGridStartFunction.class.getName());
        tag.func_74778_a("AlignToGrid", "left");
        InterModComms.sendTo((String)ID, (String)"RegisterProvider", () -> tag);
    }

    public static class GetGridStartFunction
    implements Function<GridContainer, Integer> {
        @Override
        public Integer apply(GridContainer containerGrid) {
            for (int i = 0; i < containerGrid.field_75151_b.size(); ++i) {
                if (!(containerGrid.field_75151_b.get(i) instanceof CraftingGridSlot)) continue;
                return i;
            }
            return 0;
        }
    }

    public static class ValidContainerPredicate
    implements Predicate<GridContainer> {
        @Override
        public boolean test(GridContainer containerGrid) {
            return containerGrid.getGrid().getGridType() == GridType.CRAFTING;
        }
    }
}

