/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.grid.factory.PortableGridGridFactory;
import com.refinedmods.refinedstorage.item.NetworkItem;
import com.refinedmods.refinedstorage.item.blockitem.PortableGridBlockItem;
import com.refinedmods.refinedstorage.util.PacketBufferUtils;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class OpenNetworkItemMessage {
    private final int slotId;
    private final String curioSlot;

    public OpenNetworkItemMessage(int slotId, String curioSlot) {
        this.slotId = slotId;
        this.curioSlot = curioSlot;
    }

    public static OpenNetworkItemMessage decode(PacketBuffer buf) {
        return new OpenNetworkItemMessage(buf.readInt(), PacketBufferUtils.readString(buf));
    }

    public static void encode(OpenNetworkItemMessage message, PacketBuffer buf) {
        buf.writeInt(message.slotId);
        buf.func_180714_a(message.curioSlot);
    }

    public static void handle(OpenNetworkItemMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                ItemStack stack = OpenNetworkItemMessage.getStackFromSlot(player, message.slotId, message.curioSlot);
                if (stack == null) {
                    return;
                }
                if (stack.func_77973_b() instanceof NetworkItem) {
                    ((NetworkItem)stack.func_77973_b()).applyNetwork(player.func_184102_h(), stack, n -> n.getNetworkItemManager().open((PlayerEntity)player, stack, message.slotId), err -> player.func_145747_a(err, player.func_110124_au()));
                } else if (stack.func_77973_b() instanceof PortableGridBlockItem) {
                    API.instance().getGridManager().openGrid(PortableGridGridFactory.ID, player, stack, message.slotId);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    private static ItemStack getStackFromSlot(ServerPlayerEntity player, int slotId, String curioSlot) {
        if (curioSlot.isEmpty()) {
            return player.field_71071_by.func_70301_a(slotId);
        }
        LazyOptional curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        Optional<ItemStack> stacksHandler = curiosHandler.resolve().flatMap(handler -> handler.getStacksHandler(curioSlot));
        Optional<ItemStack> stack = stacksHandler.map(handler -> handler.getStacks().getStackInSlot(slotId));
        if (stack.isPresent()) {
            return stack.get();
        }
        return null;
    }
}

